/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.boot.narayana.core.jdbc.lrco;

import com.arjuna.ats.jta.resources.LastResourceCommitOptimisation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LrcoXAResource
implements LastResourceCommitOptimisation {
    private final Connection connection;
    private Xid currentXid;

    public LrcoXAResource(Connection connection) {
        this.connection = connection;
    }

    private static XAException convertException(SQLException ex) {
        XAException xa = new XAException(ex.getMessage());
        xa.initCause(ex);
        return xa;
    }

    public synchronized void start(Xid xid, int flags) throws XAException {
        switch (flags) {
            case 0: {
                if (this.currentXid != null) {
                    throw new XAException("Already enlisted in another transaction with xid " + xid);
                }
                try {
                    this.connection.setAutoCommit(false);
                }
                catch (SQLException ex) {
                    throw (XAException)new XAException("Count not turn off auto commit for a XA transaction").initCause(ex);
                }
                this.currentXid = xid;
                break;
            }
            case 0x8000000: {
                if (xid.equals(this.currentXid)) break;
                throw new XAException("Attempting to resume in different transaction: expected " + this.currentXid + ", but was " + xid);
            }
            default: {
                throw new XAException("unknown state: " + flags);
            }
        }
    }

    public synchronized void end(Xid xid, int flags) throws XAException {
        throw new XAException(-6);
    }

    public synchronized int prepare(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        Objects.requireNonNull(xid, "xid is null");
        if (!this.currentXid.equals(xid)) {
            throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
        }
        try {
            if (this.connection.isClosed()) {
                throw new XAException("Connection is closed");
            }
            if (!this.connection.isReadOnly()) {
                this.connection.commit();
            }
        }
        catch (SQLException ex) {
            throw LrcoXAResource.convertException(ex);
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
            this.currentXid = null;
        }
    }

    public synchronized void rollback(Xid xid) throws XAException {
        Objects.requireNonNull(xid, "xid is null");
        if (!this.currentXid.equals(xid)) {
            throw new XAException("Invalid Xid: expected " + this.currentXid + ", but was " + xid);
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException ex) {
            throw LrcoXAResource.convertException(ex);
        }
        finally {
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
            this.currentXid = null;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        return new Xid[0];
    }

    public void forget(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return this == xares;
    }

    public int getTransactionTimeout() throws XAException {
        throw new XAException(-6);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }
}

