/*
  Copyright (c) 2015, 2017, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_notice.proto

public final class MysqlxNotice {
  private MysqlxNotice() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface FrameOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.Frame)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required uint32 type = 1;</code>
     */
    boolean hasType();
    /**
     * <code>required uint32 type = 1;</code>
     */
    int getType();

    /**
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     */
    boolean hasScope();
    /**
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     */
    com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope getScope();

    /**
     * <code>optional bytes payload = 3;</code>
     */
    boolean hasPayload();
    /**
     * <code>optional bytes payload = 3;</code>
     */
    com.google.protobuf.ByteString getPayload();
  }
  /**
   * Protobuf type {@code Mysqlx.Notice.Frame}
   *
   * <pre>
   * Common Frame for all Notices
   * ===================================================== =====
   * .type                                                 value
   * ===================================================== =====
   * :protobuf:msg:`Mysqlx.Notice::Warning`                1
   * :protobuf:msg:`Mysqlx.Notice::SessionVariableChanged` 2
   * :protobuf:msg:`Mysqlx.Notice::SessionStateChanged`    3
   * ===================================================== =====
   * :param type: the type of the payload
   * :param payload: the payload of the notification
   * :param scope: global or local notification
   * </pre>
   */
  public static final class Frame extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.Frame)
      FrameOrBuilder {
    // Use Frame.newBuilder() to construct.
    private Frame(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Frame(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Frame defaultInstance;
    public static Frame getDefaultInstance() {
      return defaultInstance;
    }

    public Frame getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Frame(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              type_ = input.readUInt32();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope value = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                scope_ = value;
              }
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              payload_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.Frame.class, com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Builder.class);
    }

    public static com.google.protobuf.Parser<Frame> PARSER =
        new com.google.protobuf.AbstractParser<Frame>() {
      public Frame parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Frame(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Frame> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.Frame.Scope}
     */
    public enum Scope
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>GLOBAL = 1;</code>
       */
      GLOBAL(0, 1),
      /**
       * <code>LOCAL = 2;</code>
       */
      LOCAL(1, 2),
      ;

      /**
       * <code>GLOBAL = 1;</code>
       */
      public static final int GLOBAL_VALUE = 1;
      /**
       * <code>LOCAL = 2;</code>
       */
      public static final int LOCAL_VALUE = 2;


      public final int getNumber() { return value; }

      public static Scope valueOf(int value) {
        switch (value) {
          case 1: return GLOBAL;
          case 2: return LOCAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Scope>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Scope>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Scope>() {
              public Scope findValueByNumber(int number) {
                return Scope.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDescriptor().getEnumTypes().get(0);
      }

      private static final Scope[] VALUES = values();

      public static Scope valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Scope(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.Frame.Scope)
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.Frame.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>WARNING = 1;</code>
       */
      WARNING(0, 1),
      /**
       * <code>SESSION_VARIABLE_CHANGED = 2;</code>
       */
      SESSION_VARIABLE_CHANGED(1, 2),
      /**
       * <code>SESSION_STATE_CHANGED = 3;</code>
       */
      SESSION_STATE_CHANGED(2, 3),
      ;

      /**
       * <code>WARNING = 1;</code>
       */
      public static final int WARNING_VALUE = 1;
      /**
       * <code>SESSION_VARIABLE_CHANGED = 2;</code>
       */
      public static final int SESSION_VARIABLE_CHANGED_VALUE = 2;
      /**
       * <code>SESSION_STATE_CHANGED = 3;</code>
       */
      public static final int SESSION_STATE_CHANGED_VALUE = 3;


      public final int getNumber() { return value; }

      public static Type valueOf(int value) {
        switch (value) {
          case 1: return WARNING;
          case 2: return SESSION_VARIABLE_CHANGED;
          case 3: return SESSION_STATE_CHANGED;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDescriptor().getEnumTypes().get(1);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Type(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.Frame.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <code>required uint32 type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint32 type = 1;</code>
     */
    public int getType() {
      return type_;
    }

    public static final int SCOPE_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope scope_;
    /**
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     */
    public boolean hasScope() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope getScope() {
      return scope_;
    }

    public static final int PAYLOAD_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString payload_;
    /**
     * <code>optional bytes payload = 3;</code>
     */
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bytes payload = 3;</code>
     */
    public com.google.protobuf.ByteString getPayload() {
      return payload_;
    }

    private void initFields() {
      type_ = 0;
      scope_ = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.GLOBAL;
      payload_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt32(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeEnum(2, scope_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, payload_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, scope_.getNumber());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, payload_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.Frame prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Notice.Frame}
     *
     * <pre>
     * Common Frame for all Notices
     * ===================================================== =====
     * .type                                                 value
     * ===================================================== =====
     * :protobuf:msg:`Mysqlx.Notice::Warning`                1
     * :protobuf:msg:`Mysqlx.Notice::SessionVariableChanged` 2
     * :protobuf:msg:`Mysqlx.Notice::SessionStateChanged`    3
     * ===================================================== =====
     * :param type: the type of the payload
     * :param payload: the payload of the notification
     * :param scope: global or local notification
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.Frame)
        com.mysql.cj.x.protobuf.MysqlxNotice.FrameOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.Frame.class, com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.Frame.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        type_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        scope_ = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.GLOBAL;
        bitField0_ = (bitField0_ & ~0x00000002);
        payload_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Frame result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Frame result = new com.mysql.cj.x.protobuf.MysqlxNotice.Frame(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.scope_ = scope_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.payload_ = payload_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.Frame) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.Frame)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.Frame other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasScope()) {
          setScope(other.getScope());
        }
        if (other.hasPayload()) {
          setPayload(other.getPayload());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasType()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxNotice.Frame parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxNotice.Frame) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int type_ ;
      /**
       * <code>required uint32 type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint32 type = 1;</code>
       */
      public int getType() {
        return type_;
      }
      /**
       * <code>required uint32 type = 1;</code>
       */
      public Builder setType(int value) {
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope scope_ = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.GLOBAL;
      /**
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       */
      public boolean hasScope() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope getScope() {
        return scope_;
      }
      /**
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       */
      public Builder setScope(com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       */
      public Builder clearScope() {
        bitField0_ = (bitField0_ & ~0x00000002);
        scope_ = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.GLOBAL;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString payload_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes payload = 3;</code>
       */
      public boolean hasPayload() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bytes payload = 3;</code>
       */
      public com.google.protobuf.ByteString getPayload() {
        return payload_;
      }
      /**
       * <code>optional bytes payload = 3;</code>
       */
      public Builder setPayload(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        payload_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes payload = 3;</code>
       */
      public Builder clearPayload() {
        bitField0_ = (bitField0_ & ~0x00000004);
        payload_ = getDefaultInstance().getPayload();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.Frame)
    }

    static {
      defaultInstance = new Frame(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.Frame)
  }

  public interface WarningOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.Warning)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     */
    boolean hasLevel();
    /**
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     */
    com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level getLevel();

    /**
     * <code>required uint32 code = 2;</code>
     */
    boolean hasCode();
    /**
     * <code>required uint32 code = 2;</code>
     */
    int getCode();

    /**
     * <code>required string msg = 3;</code>
     */
    boolean hasMsg();
    /**
     * <code>required string msg = 3;</code>
     */
    java.lang.String getMsg();
    /**
     * <code>required string msg = 3;</code>
     */
    com.google.protobuf.ByteString
        getMsgBytes();
  }
  /**
   * Protobuf type {@code Mysqlx.Notice.Warning}
   *
   * <pre>
   * Server-side warnings and notes
   * ``.scope`` == ``local``
   *   ``.level``, ``.code`` and ``.msg`` map the content of
   *   .. code-block:: sql
   *     SHOW WARNINGS
   * ``.scope`` == ``global``
   *   (undefined) will be used for global, unstructured messages like:
   *   * server is shutting down
   *   * a node disconnected from group
   *   * schema or table dropped
   * ========================================== =======================
   * :protobuf:msg:`Mysqlx.Notice::Frame` field value
   * ========================================== =======================
   * ``.type``                                  1
   * ``.scope``                                 ``local`` or ``global``
   * ========================================== =======================
   * :param level: warning level: Note or Warning
   * :param code: warning code
   * :param msg: warning message
   * </pre>
   */
  public static final class Warning extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.Warning)
      WarningOrBuilder {
    // Use Warning.newBuilder() to construct.
    private Warning(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Warning(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Warning defaultInstance;
    public static Warning getDefaultInstance() {
      return defaultInstance;
    }

    public Warning getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Warning(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level value = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                level_ = value;
              }
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              code_ = input.readUInt32();
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              msg_ = bs;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.Warning.class, com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Builder.class);
    }

    public static com.google.protobuf.Parser<Warning> PARSER =
        new com.google.protobuf.AbstractParser<Warning>() {
      public Warning parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Warning(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Warning> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.Warning.Level}
     */
    public enum Level
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>NOTE = 1;</code>
       */
      NOTE(0, 1),
      /**
       * <code>WARNING = 2;</code>
       */
      WARNING(1, 2),
      /**
       * <code>ERROR = 3;</code>
       */
      ERROR(2, 3),
      ;

      /**
       * <code>NOTE = 1;</code>
       */
      public static final int NOTE_VALUE = 1;
      /**
       * <code>WARNING = 2;</code>
       */
      public static final int WARNING_VALUE = 2;
      /**
       * <code>ERROR = 3;</code>
       */
      public static final int ERROR_VALUE = 3;


      public final int getNumber() { return value; }

      public static Level valueOf(int value) {
        switch (value) {
          case 1: return NOTE;
          case 2: return WARNING;
          case 3: return ERROR;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Level>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Level>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Level>() {
              public Level findValueByNumber(int number) {
                return Level.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Warning.getDescriptor().getEnumTypes().get(0);
      }

      private static final Level[] VALUES = values();

      public static Level valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Level(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.Warning.Level)
    }

    private int bitField0_;
    public static final int LEVEL_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level level_;
    /**
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     */
    public boolean hasLevel() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level getLevel() {
      return level_;
    }

    public static final int CODE_FIELD_NUMBER = 2;
    private int code_;
    /**
     * <code>required uint32 code = 2;</code>
     */
    public boolean hasCode() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required uint32 code = 2;</code>
     */
    public int getCode() {
      return code_;
    }

    public static final int MSG_FIELD_NUMBER = 3;
    private java.lang.Object msg_;
    /**
     * <code>required string msg = 3;</code>
     */
    public boolean hasMsg() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required string msg = 3;</code>
     */
    public java.lang.String getMsg() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          msg_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string msg = 3;</code>
     */
    public com.google.protobuf.ByteString
        getMsgBytes() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        msg_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private void initFields() {
      level_ = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.WARNING;
      code_ = 0;
      msg_ = "";
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCode()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasMsg()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, level_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeUInt32(2, code_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, getMsgBytes());
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, level_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, code_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getMsgBytes());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.Warning prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Notice.Warning}
     *
     * <pre>
     * Server-side warnings and notes
     * ``.scope`` == ``local``
     *   ``.level``, ``.code`` and ``.msg`` map the content of
     *   .. code-block:: sql
     *     SHOW WARNINGS
     * ``.scope`` == ``global``
     *   (undefined) will be used for global, unstructured messages like:
     *   * server is shutting down
     *   * a node disconnected from group
     *   * schema or table dropped
     * ========================================== =======================
     * :protobuf:msg:`Mysqlx.Notice::Frame` field value
     * ========================================== =======================
     * ``.type``                                  1
     * ``.scope``                                 ``local`` or ``global``
     * ========================================== =======================
     * :param level: warning level: Note or Warning
     * :param code: warning code
     * :param msg: warning message
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.Warning)
        com.mysql.cj.x.protobuf.MysqlxNotice.WarningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.Warning.class, com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.Warning.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        level_ = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.WARNING;
        bitField0_ = (bitField0_ & ~0x00000001);
        code_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        msg_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Warning.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Warning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Warning result = new com.mysql.cj.x.protobuf.MysqlxNotice.Warning(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.level_ = level_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.code_ = code_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.msg_ = msg_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.Warning) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.Warning)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.Warning other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.Warning.getDefaultInstance()) return this;
        if (other.hasLevel()) {
          setLevel(other.getLevel());
        }
        if (other.hasCode()) {
          setCode(other.getCode());
        }
        if (other.hasMsg()) {
          bitField0_ |= 0x00000004;
          msg_ = other.msg_;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasCode()) {
          
          return false;
        }
        if (!hasMsg()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxNotice.Warning parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxNotice.Warning) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level level_ = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.WARNING;
      /**
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       */
      public boolean hasLevel() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level getLevel() {
        return level_;
      }
      /**
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       */
      public Builder setLevel(com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        level_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       */
      public Builder clearLevel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        level_ = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.WARNING;
        onChanged();
        return this;
      }

      private int code_ ;
      /**
       * <code>required uint32 code = 2;</code>
       */
      public boolean hasCode() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required uint32 code = 2;</code>
       */
      public int getCode() {
        return code_;
      }
      /**
       * <code>required uint32 code = 2;</code>
       */
      public Builder setCode(int value) {
        bitField0_ |= 0x00000002;
        code_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 code = 2;</code>
       */
      public Builder clearCode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object msg_ = "";
      /**
       * <code>required string msg = 3;</code>
       */
      public boolean hasMsg() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public java.lang.String getMsg() {
        java.lang.Object ref = msg_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            msg_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public com.google.protobuf.ByteString
          getMsgBytes() {
        java.lang.Object ref = msg_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          msg_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public Builder setMsg(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        msg_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public Builder clearMsg() {
        bitField0_ = (bitField0_ & ~0x00000004);
        msg_ = getDefaultInstance().getMsg();
        onChanged();
        return this;
      }
      /**
       * <code>required string msg = 3;</code>
       */
      public Builder setMsgBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        msg_ = value;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.Warning)
    }

    static {
      defaultInstance = new Warning(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.Warning)
  }

  public interface SessionVariableChangedOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.SessionVariableChanged)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string param = 1;</code>
     */
    boolean hasParam();
    /**
     * <code>required string param = 1;</code>
     */
    java.lang.String getParam();
    /**
     * <code>required string param = 1;</code>
     */
    com.google.protobuf.ByteString
        getParamBytes();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Notice.SessionVariableChanged}
   *
   * <pre>
   * Notify clients about changes to the current session variables
   * Every change to a variable that is accessible through:
   * .. code-block:: sql
   *   SHOW SESSION VARIABLES
   * ========================================== =========
   * :protobuf:msg:`Mysqlx.Notice::Frame` field value
   * ========================================== =========
   * ``.type``                                  2
   * ``.scope``                                 ``local``
   * ========================================== =========
   * :param namespace: namespace that param belongs to
   * :param param: name of the variable
   * :param value: the changed value of param
   * </pre>
   */
  public static final class SessionVariableChanged extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.SessionVariableChanged)
      SessionVariableChangedOrBuilder {
    // Use SessionVariableChanged.newBuilder() to construct.
    private SessionVariableChanged(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private SessionVariableChanged(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final SessionVariableChanged defaultInstance;
    public static SessionVariableChanged getDefaultInstance() {
      return defaultInstance;
    }

    public SessionVariableChanged getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private SessionVariableChanged(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              param_ = bs;
              break;
            }
            case 18: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = value_.toBuilder();
              }
              value_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(value_);
                value_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.Builder.class);
    }

    public static com.google.protobuf.Parser<SessionVariableChanged> PARSER =
        new com.google.protobuf.AbstractParser<SessionVariableChanged>() {
      public SessionVariableChanged parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SessionVariableChanged(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<SessionVariableChanged> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int PARAM_FIELD_NUMBER = 1;
    private java.lang.Object param_;
    /**
     * <code>required string param = 1;</code>
     */
    public boolean hasParam() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string param = 1;</code>
     */
    public java.lang.String getParam() {
      java.lang.Object ref = param_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          param_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string param = 1;</code>
     */
    public com.google.protobuf.ByteString
        getParamBytes() {
      java.lang.Object ref = param_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        param_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue() {
      return value_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder() {
      return value_;
    }

    private void initFields() {
      param_ = "";
      value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasParam()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasValue()) {
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getParamBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getParamBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Notice.SessionVariableChanged}
     *
     * <pre>
     * Notify clients about changes to the current session variables
     * Every change to a variable that is accessible through:
     * .. code-block:: sql
     *   SHOW SESSION VARIABLES
     * ========================================== =========
     * :protobuf:msg:`Mysqlx.Notice::Frame` field value
     * ========================================== =========
     * ``.type``                                  2
     * ``.scope``                                 ``local``
     * ========================================== =========
     * :param namespace: namespace that param belongs to
     * :param param: name of the variable
     * :param value: the changed value of param
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.SessionVariableChanged)
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChangedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        param_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged result = new com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.param_ = param_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.getDefaultInstance()) return this;
        if (other.hasParam()) {
          bitField0_ |= 0x00000001;
          param_ = other.param_;
          onChanged();
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasParam()) {
          
          return false;
        }
        if (hasValue()) {
          if (!getValue().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object param_ = "";
      /**
       * <code>required string param = 1;</code>
       */
      public boolean hasParam() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string param = 1;</code>
       */
      public java.lang.String getParam() {
        java.lang.Object ref = param_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            param_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string param = 1;</code>
       */
      public com.google.protobuf.ByteString
          getParamBytes() {
        java.lang.Object ref = param_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          param_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string param = 1;</code>
       */
      public Builder setParam(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        param_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string param = 1;</code>
       */
      public Builder clearParam() {
        bitField0_ = (bitField0_ & ~0x00000001);
        param_ = getDefaultInstance().getParam();
        onChanged();
        return this;
      }
      /**
       * <code>required string param = 1;</code>
       */
      public Builder setParamBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        param_ = value;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> valueBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue() {
        if (valueBuilder_ == null) {
          return value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              value_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            value_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.newBuilder(value_).mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.SessionVariableChanged)
    }

    static {
      defaultInstance = new SessionVariableChanged(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.SessionVariableChanged)
  }

  public interface SessionStateChangedOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.SessionStateChanged)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     */
    boolean hasParam();
    /**
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter getParam();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder();
  }
  /**
   * Protobuf type {@code Mysqlx.Notice.SessionStateChanged}
   *
   * <pre>
   * Notify clients about changes to the internal session state
   * ========================================== =========
   * :protobuf:msg:`Mysqlx.Notice::Frame` field value
   * ========================================== =========
   * ``.type``                                  3
   * ``.scope``                                 ``local``
   * ========================================== =========
   * :param param: parameter key
   * :param value: updated value
   * </pre>
   */
  public static final class SessionStateChanged extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.SessionStateChanged)
      SessionStateChangedOrBuilder {
    // Use SessionStateChanged.newBuilder() to construct.
    private SessionStateChanged(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private SessionStateChanged(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final SessionStateChanged defaultInstance;
    public static SessionStateChanged getDefaultInstance() {
      return defaultInstance;
    }

    public SessionStateChanged getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private SessionStateChanged(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();
              com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter value = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(1, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                param_ = value;
              }
              break;
            }
            case 18: {
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = value_.toBuilder();
              }
              value_ = input.readMessage(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(value_);
                value_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Builder.class);
    }

    public static com.google.protobuf.Parser<SessionStateChanged> PARSER =
        new com.google.protobuf.AbstractParser<SessionStateChanged>() {
      public SessionStateChanged parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SessionStateChanged(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<SessionStateChanged> getParserForType() {
      return PARSER;
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.SessionStateChanged.Parameter}
     */
    public enum Parameter
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>CURRENT_SCHEMA = 1;</code>
       */
      CURRENT_SCHEMA(0, 1),
      /**
       * <code>ACCOUNT_EXPIRED = 2;</code>
       */
      ACCOUNT_EXPIRED(1, 2),
      /**
       * <code>GENERATED_INSERT_ID = 3;</code>
       */
      GENERATED_INSERT_ID(2, 3),
      /**
       * <code>ROWS_AFFECTED = 4;</code>
       */
      ROWS_AFFECTED(3, 4),
      /**
       * <code>ROWS_FOUND = 5;</code>
       */
      ROWS_FOUND(4, 5),
      /**
       * <code>ROWS_MATCHED = 6;</code>
       */
      ROWS_MATCHED(5, 6),
      /**
       * <code>TRX_COMMITTED = 7;</code>
       */
      TRX_COMMITTED(6, 7),
      /**
       * <code>TRX_ROLLEDBACK = 9;</code>
       */
      TRX_ROLLEDBACK(7, 9),
      /**
       * <code>PRODUCED_MESSAGE = 10;</code>
       */
      PRODUCED_MESSAGE(8, 10),
      /**
       * <code>CLIENT_ID_ASSIGNED = 11;</code>
       *
       * <pre>
       * .. more to be added
       * </pre>
       */
      CLIENT_ID_ASSIGNED(9, 11),
      ;

      /**
       * <code>CURRENT_SCHEMA = 1;</code>
       */
      public static final int CURRENT_SCHEMA_VALUE = 1;
      /**
       * <code>ACCOUNT_EXPIRED = 2;</code>
       */
      public static final int ACCOUNT_EXPIRED_VALUE = 2;
      /**
       * <code>GENERATED_INSERT_ID = 3;</code>
       */
      public static final int GENERATED_INSERT_ID_VALUE = 3;
      /**
       * <code>ROWS_AFFECTED = 4;</code>
       */
      public static final int ROWS_AFFECTED_VALUE = 4;
      /**
       * <code>ROWS_FOUND = 5;</code>
       */
      public static final int ROWS_FOUND_VALUE = 5;
      /**
       * <code>ROWS_MATCHED = 6;</code>
       */
      public static final int ROWS_MATCHED_VALUE = 6;
      /**
       * <code>TRX_COMMITTED = 7;</code>
       */
      public static final int TRX_COMMITTED_VALUE = 7;
      /**
       * <code>TRX_ROLLEDBACK = 9;</code>
       */
      public static final int TRX_ROLLEDBACK_VALUE = 9;
      /**
       * <code>PRODUCED_MESSAGE = 10;</code>
       */
      public static final int PRODUCED_MESSAGE_VALUE = 10;
      /**
       * <code>CLIENT_ID_ASSIGNED = 11;</code>
       *
       * <pre>
       * .. more to be added
       * </pre>
       */
      public static final int CLIENT_ID_ASSIGNED_VALUE = 11;


      public final int getNumber() { return value; }

      public static Parameter valueOf(int value) {
        switch (value) {
          case 1: return CURRENT_SCHEMA;
          case 2: return ACCOUNT_EXPIRED;
          case 3: return GENERATED_INSERT_ID;
          case 4: return ROWS_AFFECTED;
          case 5: return ROWS_FOUND;
          case 6: return ROWS_MATCHED;
          case 7: return TRX_COMMITTED;
          case 9: return TRX_ROLLEDBACK;
          case 10: return PRODUCED_MESSAGE;
          case 11: return CLIENT_ID_ASSIGNED;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Parameter>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static com.google.protobuf.Internal.EnumLiteMap<Parameter>
          internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Parameter>() {
              public Parameter findValueByNumber(int number) {
                return Parameter.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.getDescriptor().getEnumTypes().get(0);
      }

      private static final Parameter[] VALUES = values();

      public static Parameter valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Parameter(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.SessionStateChanged.Parameter)
    }

    private int bitField0_;
    public static final int PARAM_FIELD_NUMBER = 1;
    private com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter param_;
    /**
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     */
    public boolean hasParam() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter getParam() {
      return param_;
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue() {
      return value_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder() {
      return value_;
    }

    private void initFields() {
      param_ = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.CURRENT_SCHEMA;
      value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasParam()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasValue()) {
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeEnum(1, param_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, value_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, param_.getNumber());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Notice.SessionStateChanged}
     *
     * <pre>
     * Notify clients about changes to the internal session state
     * ========================================== =========
     * :protobuf:msg:`Mysqlx.Notice::Frame` field value
     * ========================================== =========
     * ``.type``                                  3
     * ``.scope``                                 ``local``
     * ========================================== =========
     * :param param: parameter key
     * :param value: updated value
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.SessionStateChanged)
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChangedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        param_ = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.CURRENT_SCHEMA;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.getDefaultInstance();
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged result = new com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.param_ = param_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.getDefaultInstance()) return this;
        if (other.hasParam()) {
          setParam(other.getParam());
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasParam()) {
          
          return false;
        }
        if (hasValue()) {
          if (!getValue().isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter param_ = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.CURRENT_SCHEMA;
      /**
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       */
      public boolean hasParam() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter getParam() {
        return param_;
      }
      /**
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       */
      public Builder setParam(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        param_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       */
      public Builder clearParam() {
        bitField0_ = (bitField0_ & ~0x00000001);
        param_ = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.CURRENT_SCHEMA;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> valueBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue() {
        if (valueBuilder_ == null) {
          return value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002) &&
              value_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            value_ =
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.newBuilder(value_).mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.SessionStateChanged)
    }

    static {
      defaultInstance = new SessionStateChanged(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.SessionStateChanged)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_Frame_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_Frame_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_Warning_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_Warning_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\023mysqlx_notice.proto\022\rMysqlx.Notice\032\026my" +
      "sqlx_datatypes.proto\"\307\001\n\005Frame\022\014\n\004type\030\001" +
      " \002(\r\0221\n\005scope\030\002 \001(\0162\032.Mysqlx.Notice.Fram" +
      "e.Scope:\006GLOBAL\022\017\n\007payload\030\003 \001(\014\"\036\n\005Scop" +
      "e\022\n\n\006GLOBAL\020\001\022\t\n\005LOCAL\020\002\"L\n\004Type\022\013\n\007WARN" +
      "ING\020\001\022\034\n\030SESSION_VARIABLE_CHANGED\020\002\022\031\n\025S" +
      "ESSION_STATE_CHANGED\020\003\"\205\001\n\007Warning\0224\n\005le" +
      "vel\030\001 \001(\0162\034.Mysqlx.Notice.Warning.Level:" +
      "\007WARNING\022\014\n\004code\030\002 \002(\r\022\013\n\003msg\030\003 \002(\t\")\n\005L" +
      "evel\022\010\n\004NOTE\020\001\022\013\n\007WARNING\020\002\022\t\n\005ERROR\020\003\"P",
      "\n\026SessionVariableChanged\022\r\n\005param\030\001 \002(\t\022" +
      "\'\n\005value\030\002 \001(\0132\030.Mysqlx.Datatypes.Scalar" +
      "\"\325\002\n\023SessionStateChanged\022;\n\005param\030\001 \002(\0162" +
      ",.Mysqlx.Notice.SessionStateChanged.Para" +
      "meter\022\'\n\005value\030\002 \001(\0132\030.Mysqlx.Datatypes." +
      "Scalar\"\327\001\n\tParameter\022\022\n\016CURRENT_SCHEMA\020\001" +
      "\022\023\n\017ACCOUNT_EXPIRED\020\002\022\027\n\023GENERATED_INSER" +
      "T_ID\020\003\022\021\n\rROWS_AFFECTED\020\004\022\016\n\nROWS_FOUND\020" +
      "\005\022\020\n\014ROWS_MATCHED\020\006\022\021\n\rTRX_COMMITTED\020\007\022\022" +
      "\n\016TRX_ROLLEDBACK\020\t\022\024\n\020PRODUCED_MESSAGE\020\n",
      "\022\026\n\022CLIENT_ID_ASSIGNED\020\013B\031\n\027com.mysql.cj" +
      ".x.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_Notice_Frame_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Notice_Frame_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_Frame_descriptor,
        new java.lang.String[] { "Type", "Scope", "Payload", });
    internal_static_Mysqlx_Notice_Warning_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Notice_Warning_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_Warning_descriptor,
        new java.lang.String[] { "Level", "Code", "Msg", });
    internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor,
        new java.lang.String[] { "Param", "Value", });
    internal_static_Mysqlx_Notice_SessionStateChanged_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_SessionStateChanged_descriptor,
        new java.lang.String[] { "Param", "Value", });
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
