/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.QuartzAdapter;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;

final class JobGlobalListener
implements JobListener {
    private static final Counter JOB_COUNTER = new Counter("job", "jobs.png", JdbcWrapper.SINGLETON.getSqlCounter());

    JobGlobalListener() {
    }

    static Counter getJobCounter() {
        return JOB_COUNTER;
    }

    static void initJobGlobalListener() {
        try {
            JobGlobalListener jobGlobalListener = new JobGlobalListener();
            QuartzAdapter.getSingleton().addGlobalJobListener(jobGlobalListener);
            LOG.debug("job global listener initialized");
        }
        catch (SchedulerException e) {
            LOG.info("initialization of job global listener failed, skipping", e);
        }
    }

    static void destroyJobGlobalListener() {
        try {
            QuartzAdapter.getSingleton().removeGlobalJobListener();
        }
        catch (SchedulerException e) {
            throw new IllegalStateException(e);
        }
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDetail jobDetail = QuartzAdapter.getSingleton().getContextJobDetail(context);
        String jobFullName = QuartzAdapter.getSingleton().getJobFullName(jobDetail);
        JOB_COUNTER.bindContextIncludingCpu(jobFullName);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        JOB_COUNTER.unbindContext();
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        String stackTrace;
        if (jobException == null) {
            stackTrace = null;
        } else {
            StringWriter stackTraceWriter = new StringWriter(200);
            jobException.printStackTrace(new PrintWriter(stackTraceWriter));
            stackTrace = stackTraceWriter.toString();
        }
        JOB_COUNTER.addRequestForCurrentContext(stackTrace);
    }

    public String getName() {
        return this.getClass().getName();
    }
}

