/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfPCell;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.PdfAbstractTableReport;

class PdfDatabaseInformationsReport
extends PdfAbstractTableReport {
    private final DatabaseInformations databaseInformations;

    PdfDatabaseInformationsReport(DatabaseInformations databaseInformations, Document document) {
        super(document);
        assert (databaseInformations != null);
        this.databaseInformations = databaseInformations;
    }

    @Override
    void toPdf() throws DocumentException {
        String[][] values = this.databaseInformations.getResult();
        String[] headerValues = values[0];
        this.writeTableHeaders(headerValues);
        int index = 0;
        for (String[] row : values) {
            if (index == 0) {
                ++index;
                continue;
            }
            this.nextRow();
            this.writeRow(row);
            ++index;
        }
        this.addTableToDocument();
    }

    private void writeTableHeaders(String[] headerValues) throws DocumentException {
        List<String> headers = Arrays.asList(headerValues);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        this.initTable(headers, relativeWidths);
    }

    private void writeRow(String[] row) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setVerticalAlignment(4);
        for (String value : row) {
            if (value == null || value.length() == 0) {
                this.addCell("");
                continue;
            }
            if (PdfDatabaseInformationsReport.isNumber(value)) {
                defaultCell.setHorizontalAlignment(2);
            } else {
                defaultCell.setHorizontalAlignment(0);
            }
            this.addCell(value);
        }
    }

    private static boolean isNumber(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }
}

