/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Mailer;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.CollectorDataMerge;
import net.bull.javamelody.internal.model.ConnectionInformations;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.model.HeapHistogram;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JavaInformations;
import net.bull.javamelody.internal.model.JndiBinding;
import net.bull.javamelody.internal.model.MBeanNode;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.model.RemoteCollector;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.model.UpdateChecker;
import net.bull.javamelody.internal.web.MailReport;
import org.apache.log4j.Logger;

public class CollectorServer {
    static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final int NB_COLLECT_THREADS = 10;
    private final Map<String, Throwable> lastCollectExceptionsByApplication = new ConcurrentHashMap<String, Throwable>();
    private final Map<String, RemoteCollector> remoteCollectorsByApplication = new ConcurrentHashMap<String, RemoteCollector>();
    private final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private final Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectorServer() throws IOException {
        boolean initOk = false;
        this.timer = new Timer("collector", true);
        try {
            LOGGER.info((Object)("reading applications list from: " + Parameters.getCollectorApplicationsFile()));
            Map<String, List<URL>> urlsByApplication = Parameters.getCollectorUrlsByApplications();
            LOGGER.info((Object)("monitored applications: " + urlsByApplication.keySet()));
            LOGGER.info((Object)("urls of monitored applications: " + urlsByApplication));
            Map<String, List<String>> applicationsByAggregationApplication = Parameters.getApplicationsByAggregationApplication();
            if (!applicationsByAggregationApplication.isEmpty()) {
                LOGGER.info((Object)("aggregations applications: " + applicationsByAggregationApplication.keySet()));
                LOGGER.info((Object)("aggregated applications of aggregation applications: " + applicationsByAggregationApplication));
            }
            int periodMillis = Parameters.getResolutionSeconds() * 1000;
            LOGGER.info((Object)("resolution of the monitoring in seconds: " + Parameters.getResolutionSeconds()));
            TimerTask collectTask = new TimerTask(){

                @Override
                public void run() {
                    CollectorServer.this.collectWithoutErrors();
                }
            };
            this.timer.schedule(collectTask, 100L, (long)periodMillis);
            JRobin.initBackendFactory(this.timer);
            UpdateChecker.init(this.timer, null, "Collector server");
            initOk = true;
        }
        finally {
            if (!initOk) {
                this.timer.cancel();
            }
        }
    }

    public void collectWithoutErrors() {
        try {
            LinkedHashMap<String, List<URL>> urlsByApplication = new LinkedHashMap<String, List<URL>>(Parameters.getCollectorUrlsByApplications());
            ArrayList futures = new ArrayList(this.collectForApplicationsWithoutErrors(urlsByApplication));
            Map<String, List<String>> applicationsByAggregationApplication = Parameters.getApplicationsByAggregationApplication();
            if (!applicationsByAggregationApplication.isEmpty()) {
                for (Future future : futures) {
                    future.get();
                }
                futures.clear();
                urlsByApplication.clear();
                for (String string : applicationsByAggregationApplication.keySet()) {
                    urlsByApplication.put(string, new ArrayList());
                }
                futures.addAll(this.collectForApplicationsWithoutErrors(urlsByApplication));
                for (Future future : futures) {
                    future.get();
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<Future<?>> collectForApplicationsWithoutErrors(Map<String, List<URL>> urlsByApplication) {
        ArrayList futures = new ArrayList();
        for (Map.Entry<String, List<URL>> entry : urlsByApplication.entrySet()) {
            final String application = entry.getKey();
            final List<URL> urls = entry.getValue();
            Future<?> future = this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    CollectorServer.this.collectForApplicationWithoutErrors(application, urls);
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public String collectForApplicationForAction(String application, List<URL> urls) throws IOException {
        return this.collectForApplication(new RemoteCollector(application, urls));
    }

    void collectForApplicationWithoutErrors(String application, List<URL> urls) {
        try {
            this.collectForApplication(application, urls);
            boolean becameAvailable = this.lastCollectExceptionsByApplication.containsKey(application);
            this.lastCollectExceptionsByApplication.remove(application);
            if (becameAvailable) {
                String subject = "The application " + application + " is available again for the monitoring server";
                this.notifyAdmins(subject, subject);
            }
        }
        catch (Throwable e) {
            try {
                LOGGER.warn((Object)("exception while collecting data for application " + application));
                LOGGER.warn((Object)e.toString(), e);
                boolean becameUnavailable = !this.lastCollectExceptionsByApplication.containsKey(application);
                this.lastCollectExceptionsByApplication.put(application, e);
                if (becameUnavailable) {
                    String subject = "The application " + application + " is unavailable for the monitoring server";
                    String message = subject + "\n\nCause:\n" + e.toString();
                    this.notifyAdmins(subject, message);
                }
            }
            finally {
                return;
            }
            {
            }
        }
        {
        }
    }

    String collectForApplication(String application, List<URL> urls) throws IOException {
        boolean remoteCollectorAvailable = this.isApplicationDataAvailable(application);
        RemoteCollector remoteCollector = !remoteCollectorAvailable ? new RemoteCollector(application, urls) : this.getRemoteCollectorByApplication(application);
        if (remoteCollector.isAggregationApplication()) {
            List<RemoteCollector> remoteCollectors = this.getAvailableRemoteCollectorsByApplications(Parameters.getApplicationsByAggregationApplication().get(application));
            remoteCollector.setRemoteCollectors(remoteCollectors);
        }
        String messageForReport = this.collectForApplication(remoteCollector);
        if (!remoteCollectorAvailable) {
            this.remoteCollectorsByApplication.put(application, remoteCollector);
            if (Parameter.MAIL_SESSION.getValue() != null && Parameter.ADMIN_EMAILS.getValue() != null) {
                this.scheduleReportMailForCollectorServer(application);
                LOGGER.info((Object)("Periodic report scheduled for the application " + application + " to " + Parameter.ADMIN_EMAILS.getValue()));
            }
        }
        return messageForReport;
    }

    private String collectForApplication(RemoteCollector remoteCollector) throws IOException {
        String application = remoteCollector.getApplication();
        List<URL> urls = remoteCollector.getURLs();
        LOGGER.info((Object)("collect for the application " + application + " on " + urls));
        assert (application != null);
        assert (urls != null);
        long start = System.currentTimeMillis();
        String messageForReport = remoteCollector.collectData();
        List<JavaInformations> javaInformationsList = remoteCollector.getJavaInformationsList();
        Collector collector = remoteCollector.getCollector();
        collector.collectWithoutErrors(javaInformationsList);
        LOGGER.info((Object)("collect for the application " + application + " done in " + (System.currentTimeMillis() - start) + "ms"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("counters " + application + " : " + collector.getCounters()));
            LOGGER.debug((Object)("javaInformations " + application + " : " + javaInformationsList));
            if (messageForReport != null) {
                LOGGER.debug((Object)("message " + application + " : " + messageForReport.replace("\n", ", ")));
            }
        }
        return messageForReport;
    }

    public List<SessionInformations> collectSessionInformations(String application, String sessionId) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectSessionInformations(sessionId);
    }

    public List<SamplingProfiler.SampledMethod> collectHotspots(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectHotspots();
    }

    public HeapHistogram collectHeapHistogram(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectHeapHistogram();
    }

    public DatabaseInformations collectDatabaseInformations(String application, int requestIndex) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectDatabaseInformations(requestIndex);
    }

    public List<List<ConnectionInformations>> collectConnectionInformations(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectConnectionInformations();
    }

    public String collectSqlRequestExplainPlan(String application, String sqlRequest) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectSqlRequestExplainPlan(sqlRequest);
    }

    public Map<String, List<ProcessInformations>> collectProcessInformations(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectProcessInformations();
    }

    public List<JndiBinding> collectJndiBindings(String application, String path) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectJndiBindings(path);
    }

    public Map<String, List<MBeanNode>> collectMBeans(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectMBeans();
    }

    public Map<JavaInformations, List<CounterRequestContext>> collectCurrentRequests(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectCurrentRequests();
    }

    public List<List<ThreadInformations>> getThreadInformationsLists(String application) {
        return this.getRemoteCollectorByApplication(application).getThreadInformationsLists();
    }

    public void addCollectorApplication(String application, List<URL> urls) throws IOException {
        List<URL> nodesUrls;
        if (Parameters.getApplicationsByAggregationApplication().containsKey(application)) {
            throw new IOException("An aggregation " + application + " has already been added. Choose another name.");
        }
        Map<String, List<URL>> collectorUrlsByApplications = Parameters.getCollectorUrlsByApplications();
        for (URL addedUrl : urls) {
            String addedUrlInExternalForm = addedUrl.toExternalForm();
            for (Map.Entry<String, List<URL>> entry : collectorUrlsByApplications.entrySet()) {
                for (URL existingUrl : entry.getValue()) {
                    if (!existingUrl.toExternalForm().equals(addedUrlInExternalForm)) continue;
                    throw new IOException("The URL " + addedUrlInExternalForm.substring(0, addedUrlInExternalForm.lastIndexOf(47)) + " has already been added in the application " + entry.getKey() + ". You can't monitor an application instance twice.");
                }
            }
        }
        List<URL> currentUrls = CollectorServer.getUrlsByApplication(application);
        if (currentUrls != null) {
            nodesUrls = new ArrayList<URL>(currentUrls);
            nodesUrls.addAll(urls);
            this.removeCollectorApplication(application);
        } else {
            nodesUrls = urls;
        }
        this.collectForApplication(application, nodesUrls);
        Parameters.addCollectorApplication(application, nodesUrls);
    }

    public void removeCollectorApplication(String application) throws IOException {
        Parameters.removeCollectorApplication(application);
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.remove(application);
        if (remoteCollector != null && remoteCollector.getCollector() != null) {
            remoteCollector.getCollector().stop();
        }
    }

    public void removeCollectorApplicationNodes(String appName, List<URL> nodeUrls) throws IOException {
        List<URL> currentUrls = CollectorServer.getUrlsByApplication(appName);
        if (currentUrls != null) {
            ArrayList<URL> newUrls = new ArrayList<URL>(currentUrls);
            newUrls.removeAll(nodeUrls);
            this.removeCollectorApplication(appName);
            if (!newUrls.isEmpty()) {
                this.addCollectorApplication(appName, newUrls);
            }
        }
    }

    public void addCollectorAggregationApplication(String aggregationApplication, List<String> aggregatedApplications) throws IOException {
        if (Parameters.getApplicationsByAggregationApplication().containsKey(aggregationApplication)) {
            throw new IOException("An aggregation " + aggregationApplication + " has already been added. Choose another name.");
        }
        if (Parameters.getCollectorUrlsByApplications().containsKey(aggregationApplication)) {
            throw new IOException("An application " + aggregationApplication + " has already been added. Choose another name.");
        }
        if (aggregatedApplications.size() < 2) {
            throw new IOException("Choose at least two applications to aggregate.");
        }
        this.mergeAggregatedApplications(aggregationApplication, aggregatedApplications);
        Parameters.addCollectorAggregationApplication(aggregationApplication, aggregatedApplications);
        this.collectWithoutErrors();
    }

    private void mergeAggregatedApplications(String aggregationApplication, List<String> aggregatedApplications) throws IOException {
        File targetDirectory = Parameters.getStorageDirectory(aggregationApplication);
        if (!targetDirectory.mkdirs() && !targetDirectory.exists()) {
            throw new IllegalArgumentException(targetDirectory + " can't be created");
        }
        if (targetDirectory.length() != 0L) {
            return;
        }
        ArrayList<File> sourceDirectories = new ArrayList<File>();
        for (String aggregatedApplication : aggregatedApplications) {
            sourceDirectories.add(Parameters.getStorageDirectory(aggregatedApplication));
        }
        LOGGER.info((Object)("merging data from the aggregated applications " + aggregatedApplications + " for aggregation application " + aggregationApplication));
        CollectorDataMerge collectorDataMerge = new CollectorDataMerge(sourceDirectories, targetDirectory){

            @Override
            protected void log(String msg) {
                LOGGER.info((Object)msg);
            }
        };
        collectorDataMerge.mergeDirectories();
    }

    public Collector getCollectorByApplication(String application) {
        if (application == null) {
            return null;
        }
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
        if (remoteCollector == null) {
            return null;
        }
        return remoteCollector.getCollector();
    }

    public List<JavaInformations> getJavaInformationsByApplication(String application) {
        if (application == null) {
            return null;
        }
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
        if (remoteCollector == null) {
            return null;
        }
        return remoteCollector.getJavaInformationsList();
    }

    private RemoteCollector getRemoteCollectorByApplication(String application) {
        assert (application != null);
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
        assert (remoteCollector != null);
        return remoteCollector;
    }

    private List<RemoteCollector> getAvailableRemoteCollectorsByApplications(List<String> applications) {
        ArrayList<RemoteCollector> remoteCollectors = new ArrayList<RemoteCollector>();
        for (String application : applications) {
            RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
            if (remoteCollector == null) continue;
            remoteCollectors.add(remoteCollector);
        }
        return remoteCollectors;
    }

    public boolean isApplicationDataAvailable(String application) {
        assert (application != null);
        return this.remoteCollectorsByApplication.containsKey(application);
    }

    public String getFirstApplication() {
        if (this.remoteCollectorsByApplication.isEmpty()) {
            return null;
        }
        return this.remoteCollectorsByApplication.keySet().iterator().next();
    }

    public Map<String, Throwable> getLastCollectExceptionsByApplication() {
        return Collections.unmodifiableMap(this.lastCollectExceptionsByApplication);
    }

    private void notifyAdmins(String subject, String message) {
        String mailSession = Parameter.MAIL_SESSION.getValue();
        String adminEmails = Parameter.ADMIN_EMAILS.getValue();
        if (mailSession != null && adminEmails != null) {
            Mailer mailer = new Mailer(mailSession);
            try {
                mailer.send(adminEmails, subject, message, null, false);
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.toString(), (Throwable)e);
            }
        }
    }

    void scheduleReportMailForCollectorServer(String application) {
        assert (application != null);
        for (Period period : MailReport.getMailPeriods()) {
            this.scheduleReportMailForCollectorServer(application, period);
        }
    }

    void scheduleReportMailForCollectorServer(final String application, final Period period) {
        assert (application != null);
        assert (period != null);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    Collector collector = CollectorServer.this.getCollectorByApplication(application);
                    List<JavaInformations> javaInformationsList = CollectorServer.this.getJavaInformationsByApplication(application);
                    new MailReport().sendReportMail(collector, true, javaInformationsList, period);
                }
                catch (Throwable t) {
                    LOG.warn("sending mail report failed", t);
                }
                CollectorServer.this.scheduleReportMailForCollectorServer(application, period);
            }
        };
        this.timer.schedule(task, MailReport.getNextExecutionDate(period));
    }

    public void stop() {
        this.timer.cancel();
        this.executorService.shutdown();
        for (RemoteCollector remoteCollector : this.remoteCollectorsByApplication.values()) {
            remoteCollector.getCollector().stop();
        }
        this.remoteCollectorsByApplication.clear();
    }

    public static List<URL> getUrlsByApplication(String application) throws IOException {
        assert (application != null);
        return Parameters.getCollectorUrlsByApplications().get(application);
    }
}

