/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("java.awt.headless", "true");
        File me = Main.whoAmI();
        Main.getSystemOutputStream().println("Running from: " + me);
        System.setProperty("executable-war", me.getAbsolutePath());
        File tmpJar = Main.extractFromJar("/winstone-jenkins.jar", "winstone", "jar");
        File tempFile = File.createTempFile("dummy", "dummy");
        Main.deleteContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        Main.deleteFile(tempFile);
        URLClassLoader cl = new URLClassLoader(new URL[]{tmpJar.toURI().toURL()});
        Class<?> launcher = cl.loadClass("winstone.Launcher");
        Method mainMethod = launcher.getMethod("main", String[].class);
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        Field usage = launcher.getField("USAGE");
        usage.set(null, "JavaMelody Monitoring Collect Server \nUsage: java -jar javamelody.war [--option=value] [--option=value]\n\nOptions:\n   --config                 = load configuration properties from here. Default is ./winstone.properties\n   --prefix                 = add this prefix to all URLs (eg http://localhost:8080/prefix/resource). Default is none\n   --commonLibFolder        = folder for additional jar files. Default is ./lib\n   \n   --logThrowingLineNo      = show the line no that logged the message (slow). Default is false\n   --logThrowingThread      = show the thread that logged the message. Default is false\n   --debug                  = set the level of debug msgs (1-9). Default is 5 (INFO level)\n\n   --httpPort               = set the http listening port. -1 to disable, Default is 8080\n   --httpListenAddress      = set the http listening address. Default is all interfaces\n   --httpDoHostnameLookups  = enable host name lookups on incoming http connections (true/false). Default is false\n   --httpKeepAliveTimeout   = how long idle HTTP keep-alive connections are kept around (in ms; default 5000)?\n   --httpsPort              = set the https listening port. -1 to disable, Default is disabled\n                              if neither --httpsCertificate nor --httpsKeyStore are specified,\n                              https is run with one-time self-signed certificate.\n   --httpsListenAddress     = set the https listening address. Default is all interfaces\n   --httpsDoHostnameLookups = enable host name lookups on incoming https connections (true/false). Default is false\n   --httpsKeepAliveTimeout   = how long idle HTTPS keep-alive connections are kept around (in ms; default 5000)?\n   --httpsKeyStore          = the location of the SSL KeyStore file.\n   --httpsKeyStorePassword  = the password for the SSL KeyStore file. Default is null\n   --httpsCertificate       = the location of the PEM-encoded SSL certificate file.\n                              (the one that starts with '-----BEGIN CERTIFICATE-----')\n                              must be used with --httpsPrivateKey.\n   --httpsPrivateKey        = the location of the PEM-encoded SSL private key.\n                              (the one that starts with '-----BEGIN RSA PRIVATE KEY-----')\n   --httpsKeyManagerType    = the SSL KeyManagerFactory type (eg SunX509, IbmX509). Default is SunX509\n   --spdy                   = Enable SPDY. See http://wiki.eclipse.org/Jetty/Feature/NPN\n   --ajp13Port              = set the ajp13 listening port. -1 to disable, Default is disabled\n   --ajp13ListenAddress     = set the ajp13 listening address. Default is all interfaces\n   --controlPort            = set the shutdown/control port. -1 to disable, Default disabled\n   \n   --handlerCountStartup    = set the no of worker threads to spawn at startup. Default is 5\n   --handlerCountMax        = set the max no of worker threads to allow. Default is 40\n   --handlerCountMaxIdle    = set the max no of idle worker threads to allow. Default is 5\n   \n   --sessionTimeout         = set the http session timeout value in minutes. Default to what webapp specifies, and then to 60 minutes\n   --mimeTypes=ARG          = define additional MIME type mappings. ARG would be EXT=MIMETYPE:EXT=MIMETYPE:...\n                              (e.g., xls=application/vnd.ms-excel:wmf=application/x-msmetafile)\n   --maxParamCount=N        = set the max number of parameters allowed in a form submission to protect\n                              against hash DoS attack (oCERT #2011-003). Default is 10000.\n   --usage / --help         = show this message\n   \nAccess logging:\n   --accessLoggerClassName        = Set the access logger class to use for user authentication. Defaults to disabled\n   --simpleAccessLogger.format    = The log format to use. Supports combined/common/resin/custom (SimpleAccessLogger only)\n   --simpleAccessLogger.file      = The location pattern for the log file(SimpleAccessLogger only)");
        mainMethod.invoke(null, new Object[]{arguments.toArray(new String[arguments.size()])});
    }

    private static File whoAmI() throws IOException {
        try {
            return Main.whoAmIFromJnlp();
        }
        catch (Exception x) {
            Main.getSystemErrorStream().println("INFO: ZipFile.name trick did not work (" + x.toString() + "), using fallback");
            File myself = File.createTempFile("javamelody", ".jar");
            myself.deleteOnExit();
            try (InputStream is = Main.class.getProtectionDomain().getCodeSource().getLocation().openStream();
                 FileOutputStream os = new FileOutputStream(myself);){
                Main.copyStream(is, os);
            }
            return myself;
        }
    }

    private static PrintStream getSystemOutputStream() {
        return System.out;
    }

    private static PrintStream getSystemErrorStream() {
        return System.err;
    }

    private static File whoAmIFromJnlp() throws Exception {
        URL classFile = Main.class.getClassLoader().getResource("Main.class");
        JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
        Field f = ZipFile.class.getDeclaredField("name");
        f.setAccessible(true);
        return new File((String)f.get(jf));
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    private static File extractFromJar(String resource, String fileName, String suffix) throws IOException {
        File tmp;
        URL res = Main.class.getResource(resource);
        try {
            tmp = File.createTempFile(fileName, suffix);
        }
        catch (IOException e) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            throw new IllegalStateException("JavaMelody has failed to create a temporary file in " + tmpdir, e);
        }
        try (InputStream is = res.openStream();
             FileOutputStream os = new FileOutputStream(tmp);){
            Main.copyStream(is, os);
        }
        tmp.deleteOnExit();
        return tmp;
    }

    private static void deleteContents(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File file2 : files) {
                Main.deleteContents(file2);
            }
        }
        Main.deleteFile(file);
    }

    private static boolean deleteFile(File file) {
        return file.delete();
    }
}

