/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.bull.javamelody.internal.model.MBeans;

final class MBeansAccessor {
    private static final MBeanServer MBEAN_SERVER = MBeans.getPlatformMBeanServer();
    private static final Set<ObjectName> NIO_BUFFER_POOLS = MBeansAccessor.getNioBufferPools();
    private static final ObjectName OPERATING_SYSTEM = MBeansAccessor.createObjectName("java.lang:type=OperatingSystem");
    private static final Set<String> OPERATING_SYSTEM_ATTRIBUTES = MBeansAccessor.getAttributesNames(OPERATING_SYSTEM);
    private static final ObjectName THREADING = MBeansAccessor.createObjectName("java.lang:type=Threading");
    private static final boolean MBEAN_ALLOCATED_BYTES_ENABLED = MBeansAccessor.isMbeanAllocatedBytesEnabled();
    private static final String[] THREAD_ALLOCATED_BYTES_SIGNATURE = new String[]{Long.TYPE.getName()};

    private MBeansAccessor() {
    }

    static Set<ObjectName> getTomcatThreadPools() {
        HashSet<ObjectName> result = new HashSet<ObjectName>(MBEAN_SERVER.queryNames(MBeansAccessor.createObjectName("*:type=ThreadPool,*"), null));
        result.removeAll(MBEAN_SERVER.queryNames(MBeansAccessor.createObjectName("*:type=ThreadPool,*,subType=SocketProperties"), null));
        return result;
    }

    static Set<ObjectName> getTomcatGlobalRequestProcessors() {
        return MBEAN_SERVER.queryNames(MBeansAccessor.createObjectName("*:type=GlobalRequestProcessor,*"), null);
    }

    private static Set<ObjectName> getNioBufferPools() {
        return MBEAN_SERVER.queryNames(MBeansAccessor.createObjectName("java.nio:type=BufferPool,*"), null);
    }

    static long getUsedBufferMemory() {
        if (NIO_BUFFER_POOLS.isEmpty()) {
            return -1L;
        }
        long result = 0L;
        try {
            for (ObjectName objectName : NIO_BUFFER_POOLS) {
                result += ((Long)MBeansAccessor.getAttribute(objectName, "MemoryUsed")).longValue();
            }
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    static <T> T getAttribute(ObjectName name, String attribute) throws JMException {
        return (T)MBEAN_SERVER.getAttribute(name, attribute);
    }

    static long getLongFromOperatingSystem(String attribute) {
        if (!OPERATING_SYSTEM_ATTRIBUTES.contains(attribute)) {
            return -1L;
        }
        try {
            return (Long)MBeansAccessor.getAttribute(OPERATING_SYSTEM, attribute);
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    static double getDoubleFromOperatingSystem(String attribute) {
        if (!OPERATING_SYSTEM_ATTRIBUTES.contains(attribute)) {
            return -1.0;
        }
        try {
            return (Double)MBeansAccessor.getAttribute(OPERATING_SYSTEM, attribute);
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    static long getThreadAllocatedBytes(long threadId) {
        if (!MBEAN_ALLOCATED_BYTES_ENABLED) {
            return -1L;
        }
        try {
            return (Long)MBEAN_SERVER.invoke(THREADING, "getThreadAllocatedBytes", new Object[]{threadId}, THREAD_ALLOCATED_BYTES_SIGNATURE);
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    static Object invoke(ObjectName name, String operationName, Object[] params, Class<?>[] classes) throws JMException {
        assert (name != null);
        assert (operationName != null);
        assert (params != null);
        assert (classes != null);
        String[] signature = new String[classes.length];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = classes[i].getName();
        }
        return MBEAN_SERVER.invoke(name, operationName, params, signature);
    }

    private static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Set<String> getAttributesNames(ObjectName name) {
        try {
            MBeanAttributeInfo[] attributes;
            HashSet<String> result = new HashSet<String>();
            MBeanInfo mBeanInfo = MBEAN_SERVER.getMBeanInfo(name);
            for (MBeanAttributeInfo attribute : attributes = mBeanInfo.getAttributes()) {
                if (!attribute.isReadable()) continue;
                result.add(attribute.getName());
            }
            return result;
        }
        catch (JMException e) {
            return Collections.emptySet();
        }
    }

    private static boolean isMbeanAllocatedBytesEnabled() {
        if (MBeansAccessor.getAttributesNames(THREADING).contains("ThreadAllocatedMemoryEnabled")) {
            try {
                boolean supported = (Boolean)MBeansAccessor.getAttribute(THREADING, "ThreadAllocatedMemorySupported");
                if (supported) {
                    return (Boolean)MBeansAccessor.getAttribute(THREADING, "ThreadAllocatedMemoryEnabled");
                }
            }
            catch (JMException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return false;
    }
}

