/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.Option;
import com.kscs.util.plugins.xjc.base.PluginUsageBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;

public class MarkdownPluginUsageBuilder
extends PluginUsageBuilder {
    private final StringWriter stringWriter = new StringWriter();
    private final PrintWriter writer = new PrintWriter(this.stringWriter);

    public MarkdownPluginUsageBuilder(ResourceBundle baseResourceBundle, ResourceBundle resourceBundle) {
        super(baseResourceBundle, resourceBundle);
    }

    @Override
    public MarkdownPluginUsageBuilder addMain(String optionName) {
        this.writer.println("## " + optionName);
        for (PluginUsageBuilder.Section section : this.getSections()) {
            this.writer.println("### " + section.title);
            if (section.body == null) continue;
            this.writer.println(section.body);
            this.writer.println();
        }
        this.writer.println("### " + this.baseResourceBundle.getString(this.keyBase + ".usage"));
        this.writer.println("#### -X" + optionName);
        return this;
    }

    @Override
    public <T> MarkdownPluginUsageBuilder addOption(Option<?> option) {
        if (this.firstOption) {
            this.firstOption = false;
            this.writer.println("\n#### " + this.baseResourceBundle.getString(this.keyBase + ".options"));
        }
        String key = this.keyBase + "." + MarkdownPluginUsageBuilder.transformName(option.getName());
        this.writer.println();
        this.writer.print("##### -");
        this.writer.println(option.getPluginName() + "." + option.getName() + "=`" + option.getChoice() + "` (" + option.getStringValue() + ")");
        this.writer.println(this.resourceBundle.getString(key));
        this.writer.println();
        return this;
    }

    public String build() {
        this.writer.close();
        return this.stringWriter.toString();
    }
}

