/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.doc;

import com.kscs.util.plugins.xjc.base.AbstractPlugin;
import com.kscs.util.plugins.xjc.base.HtmlUsageBuilder;
import com.kscs.util.plugins.xjc.base.MarkdownPluginUsageBuilder;
import com.kscs.util.plugins.xjc.base.Option;
import com.kscs.util.plugins.xjc.base.PropertyDirectoryResourceBundle;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class PluginDocumentationFormatter {
    public static final Pattern INDEX_PATTERN = Pattern.compile("^\\[\\d\\]: .*$");
    public static final ResourceBundle RES = PropertyDirectoryResourceBundle.getInstance(PluginDocumentationFormatter.class);
    private final ResourceBundle baseResourceBundle;
    private final ResourceBundle resourceBundle;
    private final Locale locale;
    private final AbstractPlugin plugin;

    protected PluginDocumentationFormatter(AbstractPlugin plugin, Locale locale) {
        this.plugin = plugin;
        this.baseResourceBundle = PropertyDirectoryResourceBundle.getInstance(AbstractPlugin.class, locale);
        this.resourceBundle = PropertyDirectoryResourceBundle.getInstance(((Object)((Object)plugin)).getClass(), locale);
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public AbstractPlugin getPlugin() {
        return this.plugin;
    }

    public Document getUsageHtml(Node parent) {
        HtmlUsageBuilder pluginUsageBuilder = new HtmlUsageBuilder(this.baseResourceBundle, this.resourceBundle);
        pluginUsageBuilder.addMain(this.plugin.getOptionName().substring(1));
        for (Option<?> option : this.plugin.getOptions()) {
            pluginUsageBuilder.addOption((Option)option);
        }
        return pluginUsageBuilder.build(parent);
    }

    public String getUsageMarkdown() {
        MarkdownPluginUsageBuilder pluginUsageBuilder = new MarkdownPluginUsageBuilder(this.baseResourceBundle, this.resourceBundle);
        pluginUsageBuilder.addMain(this.plugin.getOptionName().substring(1));
        for (Option<?> option : this.plugin.getOptions()) {
            pluginUsageBuilder.addOption((Option)option);
        }
        return pluginUsageBuilder.build();
    }

    public String getUsageFileName() {
        return this.plugin.getOptionName().substring(1) + (String)(Locale.ROOT.equals(this.locale) ? "" : "_" + this.locale.toLanguageTag());
    }

    public String getConfigCheatSheet(int tabAmount, final String argPrefix, final String argSuffix) {
        final class A {
            A() {
            }

            private String arg(String s) {
                return argPrefix + s + argSuffix;
            }

            private String tab(int tabAmount) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < tabAmount; ++i) {
                    sb.append("    ");
                }
                return sb.toString();
            }
        }
        A a = new A();
        StringWriter sw = new StringWriter();
        try (PrintWriter w = new PrintWriter(sw);){
            w.print(a.tab(tabAmount));
            w.println(a.arg(this.plugin.getOptionName()));
            for (Option<?> option : this.plugin.getOptions()) {
                w.print(a.tab(tabAmount + 1));
                w.println(a.arg(option.getPluginName() + "." + option.getName() + "=" + option.getStringValue()));
            }
            w.flush();
            String string = sw.toString();
            return string;
        }
    }
}

