/*
 * Decompiled with CFR 0.152.
 */
package com.redis.cluster;

import com.redis.RedisClient;
import com.redis.RedisClientPool;
import com.redis.RedisCommand;
import com.redis.api.BaseApi;
import com.redis.api.HashApi;
import com.redis.api.SetApi;
import com.redis.api.SortedSetApi;
import com.redis.api.StringApi;
import com.redis.cluster.BaseOps;
import com.redis.cluster.EvalOps;
import com.redis.cluster.HashOps;
import com.redis.cluster.HashRing;
import com.redis.cluster.KeyTag;
import com.redis.cluster.ListOps;
import com.redis.cluster.NodeOps;
import com.redis.cluster.RedisClusterOps;
import com.redis.cluster.SetOps;
import com.redis.cluster.SortedSetOps;
import com.redis.cluster.StringOps;
import com.redis.cluster.WithHashRing;
import com.redis.cluster.package;
import com.redis.package;
import com.redis.serialization.Format;
import com.redis.serialization.Parse;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\n\u0014\u0001iA\u0001\"\u0013\u0001\u0003\u0006\u0004%\tB\u0013\u0005\t7\u0002\u0011\t\u0011)A\u0005\u0017\"AA\f\u0001BC\u0002\u0013ES\f\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003_\u0011\u00151\u0007\u0001\"\u0001h\u0011!Y\u0007A1A\u0005\u0012Ma\u0007B\u00028\u0001A\u0003%Q\u000e\u0003\u0005p\u0001\t\u0007I\u0011K\nq\u0011\u0019!\b\u0001)A\u0005c\")Q\u000f\u0001C!m\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u0019\t\u0019\u0005\u0001C!\u0015\"A\u0011Q\t\u0001\u0005RM\t9\u0005C\u0004\u0002t\u0001!\t%!\u001e\t\u0011\u0005]\u0004\u0001\"\u0015\u0014\u0003s\u0012ABU3eSN\u001cE.^:uKJT!\u0001F\u000b\u0002\u000f\rdWo\u001d;fe*\u0011acF\u0001\u0006e\u0016$\u0017n\u001d\u0006\u00021\u0005\u00191m\\7\u0004\u0001Ma\u0001aG\u0012(cQ:$(\u0010!D\rB\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB(cU\u0016\u001cG\u000f\u0005\u0002%K5\t1#\u0003\u0002''\ty!+\u001a3jg\u000ecWo\u001d;fe>\u00038\u000fE\u0002%Q)J!!K\n\u0003\u0019]KG\u000f\u001b%bg\"\u0014\u0016N\\4\u0011\u0005-rcB\u0001\u0013-\u0013\ti3#A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0002$aG%eK:$\u0018NZ5bE2,'+\u001a3jg\u000ec\u0017.\u001a8u!>|GN\u0003\u0002.'A\u0011AEM\u0005\u0003gM\u0011qAQ1tK>\u00038\u000f\u0005\u0002%k%\u0011ag\u0005\u0002\b\u001d>$Wm\u00149t!\t!\u0003(\u0003\u0002:'\tI1\u000b\u001e:j]\u001e|\u0005o\u001d\t\u0003ImJ!\u0001P\n\u0003\u000f1K7\u000f^(qgB\u0011AEP\u0005\u0003\u007fM\u0011aaU3u\u001fB\u001c\bC\u0001\u0013B\u0013\t\u00115C\u0001\u0007T_J$X\rZ*fi>\u00038\u000f\u0005\u0002%\t&\u0011Qi\u0005\u0002\b\u000bZ\fGn\u00149t!\t!s)\u0003\u0002I'\t9\u0001*Y:i\u001fB\u001c\u0018!\u00025pgR\u001cX#A&\u0011\u00071+\u0006L\u0004\u0002N':\u0011a*U\u0007\u0002\u001f*\u0011\u0001+G\u0001\u0007yI|w\u000e\u001e \n\u0003I\u000bQa]2bY\u0006L!!\f+\u000b\u0003IK!AV,\u0003\t1K7\u000f\u001e\u0006\u0003[Q\u0003\"aK-\n\u0005i\u0003$aC\"mkN$XM\u001d(pI\u0016\fa\u0001[8tiN\u0004\u0013AB6fsR\u000bw-F\u0001_!\ry\u0006MY\u0007\u0002)&\u0011\u0011\r\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011\u001a\u0017B\u00013\u0014\u0005\u0019YU-\u001f+bO\u000691.Z=UC\u001e\u0004\u0013A\u0002\u001fj]&$h\bF\u0002iS*\u0004\"\u0001\n\u0001\t\u000b%+\u0001\u0019A&\t\u000bq+\u0001\u0019\u00010\u0002\u000f\rd\u0017.\u001a8ugV\tQ\u000eE\u0002M+*\n\u0001b\u00197jK:$8\u000fI\u0001\u0003QJ,\u0012!\u001d\t\u0004IIT\u0013BA:\u0014\u0005!A\u0015m\u001d5SS:<\u0017a\u00015sA\u0005Qan\u001c3f\r>\u00148*Z=\u0015\u0007]\f\t\u0001\u0006\u0002+q\")\u0011P\u0003a\u0002u\u00061am\u001c:nCR\u0004\"a\u001f@\u000e\u0003qT!!`\u000b\u0002\u001bM,'/[1mSj\fG/[8o\u0013\tyHP\u0001\u0004G_Jl\u0017\r\u001e\u0005\b\u0003\u0007Q\u0001\u0019AA\u0003\u0003\rYW-\u001f\t\u0004?\u0006\u001d\u0011bAA\u0005)\n\u0019\u0011I\\=\u0002\u0013\u0005$GmU3sm\u0016\u0014H\u0003BA\b\u0003C\u0001b!!\u0005\u0002\u0018\u0005mQBAA\n\u0015\r\t)\u0002V\u0001\u0005kRLG.\u0003\u0003\u0002\u001a\u0005M!a\u0001+ssB\u0019q,!\b\n\u0007\u0005}AK\u0001\u0003V]&$\bBBA\u0012\u0017\u0001\u0007\u0001,\u0001\u0004tKJ4XM]\u0001\u000ee\u0016\u0004H.Y2f'\u0016\u0014h/\u001a:\u0015\t\u0005m\u0011\u0011\u0006\u0005\u0007\u0003Ga\u0001\u0019\u0001-\u0002\u0019I,Wn\u001c<f'\u0016\u0014h/\u001a:\u0015\t\u0005m\u0011q\u0006\u0005\b\u0003ci\u0001\u0019AA\u001a\u0003!qw\u000eZ3oC6,\u0007\u0003BA\u001b\u0003{qA!a\u000e\u0002:A\u0011a\nV\u0005\u0004\u0003w!\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002@\u0005\u0005#AB*ue&twMC\u0002\u0002<Q\u000b1\u0002\\5tiN+'O^3sg\u0006QqN\\!mY\u000e{gN\\:\u0016\t\u0005%\u0013Q\u000b\u000b\u0005\u0003\u0017\n\t\u0007E\u0003M\u0003\u001b\n\t&C\u0002\u0002P]\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003'\n)\u0006\u0004\u0001\u0005\u000f\u0005]sB1\u0001\u0002Z\t\tA+\u0005\u0003\u0002\\\u0005\u0015\u0001cA0\u0002^%\u0019\u0011q\f+\u0003\u000f9{G\u000f[5oO\"9\u00111M\bA\u0002\u0005\u0015\u0014\u0001\u00022pIf\u0004raXA4\u0003W\n\t&C\u0002\u0002jQ\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u00055\u0014qN\u0007\u0002+%\u0019\u0011\u0011O\u000b\u0003\u0017I+G-[:DY&,g\u000e^\u0001\u0006G2|7/\u001a\u000b\u0003\u00037\t!B]1oI>lgj\u001c3f)\t\tY\b\u0005\u0003\u0002n\u0005u\u0014bAA@+\ty!+\u001a3jg\u000ec\u0017.\u001a8u!>|G\u000e")
public class RedisCluster
implements RedisClusterOps,
WithHashRing<package.IdentifiableRedisClientPool>,
BaseOps,
NodeOps,
StringOps,
ListOps,
SetOps,
SortedSetOps,
EvalOps,
HashOps {
    private final List<package.ClusterNode> hosts;
    private final Option<KeyTag> keyTag;
    private final List<package.IdentifiableRedisClientPool> clients;
    private final HashRing<package.IdentifiableRedisClientPool> hr;
    private final Some<Object> com$redis$cluster$EvalOps$$scriptExistsNot;
    private final Option<String> pong;
    private final Random r;
    private final int POINTS_PER_SERVER;

    @Override
    public boolean hset(Object key, Object field, Object value, Format format) {
        return HashOps.hset$(this, key, field, value, format);
    }

    @Override
    public Option<Object> hset1(Object key, Object field, Object value, Format format) {
        return HashOps.hset1$(this, key, field, value, format);
    }

    @Override
    public <A> Option<A> hget(Object key, Object field, Format format, Parse<A> parse) {
        return HashOps.hget$(this, key, field, format, parse);
    }

    @Override
    public boolean hmset(Object key, Iterable<Product2<Object, Object>> map, Format format) {
        return HashOps.hmset$(this, key, map, format);
    }

    @Override
    public <K, V> Option<Map<K, V>> hmget(Object key, Seq<K> fields, Format format, Parse<V> parseV) {
        return HashOps.hmget$(this, key, fields, format, parseV);
    }

    @Override
    public Option<Object> hincrby(Object key, Object field, long value, Format format) {
        return HashOps.hincrby$(this, key, field, value, format);
    }

    @Override
    public boolean hexists(Object key, Object field, Format format) {
        return HashOps.hexists$(this, key, field, format);
    }

    @Override
    public Option<Object> hdel(Object key, Object field, Seq<Object> fields, Format format) {
        return HashOps.hdel$(this, key, field, fields, format);
    }

    @Override
    public Option<Object> hlen(Object key, Format format) {
        return HashOps.hlen$(this, key, format);
    }

    @Override
    public <A> Option<List<A>> hkeys(Object key, Format format, Parse<A> parse) {
        return HashOps.hkeys$(this, key, format, parse);
    }

    @Override
    public <A> Option<List<A>> hvals(Object key, Format format, Parse<A> parse) {
        return HashOps.hvals$(this, key, format, parse);
    }

    @Override
    public <K, V> Option<Map<K, V>> hgetall(Object key, Format format, Parse<K> parseK, Parse<V> parseV) {
        return HashOps.hgetall$(this, key, format, parseK, parseV);
    }

    @Override
    public <K, V> Option<Map<K, V>> hgetall1(Object key, Format format, Parse<K> parseK, Parse<V> parseV) {
        return HashOps.hgetall1$(this, key, format, parseK, parseV);
    }

    @Override
    public boolean hsetnx(Object key, Object field, Object value, Format format) {
        return HashOps.hsetnx$(this, key, field, value, format);
    }

    @Override
    public Option<Object> hincrbyfloat(Object key, Object field, float value, Format format) {
        return HashOps.hincrbyfloat$(this, key, field, value, format);
    }

    @Override
    public <A> Option<Tuple2<Option<Object>, Option<List<Option<A>>>>> hscan(Object key, int cursor, Object pattern, int count, Format format, Parse<A> parse) {
        return HashOps.hscan$(this, key, cursor, pattern, count, format, parse);
    }

    @Override
    public <A> Object hscan$default$3() {
        return HashApi.hscan$default$3$(this);
    }

    @Override
    public <A> int hscan$default$4() {
        return HashApi.hscan$default$4$(this);
    }

    @Override
    public <A> Option<List<Option<A>>> evalMultiBulk(String luaCode, List<Object> keys, List<Object> args, Format format, Parse<A> parse) {
        return EvalOps.evalMultiBulk$(this, luaCode, keys, args, format, parse);
    }

    @Override
    public <A> Option<A> evalBulk(String luaCode, List<Object> keys, List<Object> args, Format format, Parse<A> parse) {
        return EvalOps.evalBulk$(this, luaCode, keys, args, format, parse);
    }

    @Override
    public Option<Object> evalInt(String luaCode, List<Object> keys, List<Object> args) {
        return EvalOps.evalInt$(this, luaCode, keys, args);
    }

    @Override
    public <A> Option<List<Option<A>>> evalMultiSHA(String shahash, List<Object> keys, List<Object> args, Format format, Parse<A> parse) {
        return EvalOps.evalMultiSHA$(this, shahash, keys, args, format, parse);
    }

    @Override
    public <A> Option<A> evalSHA(String shahash, List<Object> keys, List<Object> args, Format format, Parse<A> parse) {
        return EvalOps.evalSHA$(this, shahash, keys, args, format, parse);
    }

    @Override
    public <A> Option<A> evalSHABulk(String shahash, List<Object> keys, List<Object> args, Format format, Parse<A> parse) {
        return EvalOps.evalSHABulk$(this, shahash, keys, args, format, parse);
    }

    @Override
    public Option<String> scriptLoad(String luaCode) {
        return EvalOps.scriptLoad$(this, luaCode);
    }

    @Override
    public Option<Object> scriptExists(String shahash) {
        return EvalOps.scriptExists$(this, shahash);
    }

    @Override
    public Option<String> scriptFlush() {
        return EvalOps.scriptFlush$(this);
    }

    @Override
    public <A> Option<A> oneCommonAnswerOr(Iterable<A> r, Function1<Iterable<A>, Option<A>> moreResultHandler) {
        return EvalOps.oneCommonAnswerOr$(this, r, moreResultHandler);
    }

    @Override
    public Option<Object> zadd(Object key, double score, Object member, Seq<Tuple2<Object, Object>> scoreVals, Format format) {
        return SortedSetOps.zadd$(this, key, score, member, scoreVals, format);
    }

    @Override
    public Option<Object> zrem(Object key, Object member, Seq<Object> members, Format format) {
        return SortedSetOps.zrem$(this, key, member, members, format);
    }

    @Override
    public Option<Object> zincrby(Object key, double incr, Object member, Format format) {
        return SortedSetOps.zincrby$(this, key, incr, member, format);
    }

    @Override
    public Option<Object> zcard(Object key, Format format) {
        return SortedSetOps.zcard$(this, key, format);
    }

    @Override
    public Option<Object> zscore(Object key, Object element, Format format) {
        return SortedSetOps.zscore$(this, key, element, format);
    }

    @Override
    public <A> Option<List<A>> zrange(Object key, int start, int end, RedisClient.SortOrder sortAs, Format format, Parse<A> parse) {
        return SortedSetOps.zrange$(this, key, start, end, sortAs, format, parse);
    }

    @Override
    public <A> int zrange$default$2() {
        return SortedSetOps.zrange$default$2$(this);
    }

    @Override
    public <A> int zrange$default$3() {
        return SortedSetOps.zrange$default$3$(this);
    }

    @Override
    public <A> Option<List<Tuple2<A, Object>>> zrangeWithScore(Object key, int start, int end, RedisClient.SortOrder sortAs, Format format, Parse<A> parse) {
        return SortedSetOps.zrangeWithScore$(this, key, start, end, sortAs, format, parse);
    }

    @Override
    public <A> int zrangeWithScore$default$2() {
        return SortedSetOps.zrangeWithScore$default$2$(this);
    }

    @Override
    public <A> int zrangeWithScore$default$3() {
        return SortedSetOps.zrangeWithScore$default$3$(this);
    }

    @Override
    public <A> RedisClient.SortOrder zrangeWithScore$default$4() {
        return SortedSetOps.zrangeWithScore$default$4$(this);
    }

    @Override
    public <A> Option<List<A>> zrangebyscore(Object key, double min, boolean minInclusive, double max, boolean maxInclusive, Option<Tuple2<Object, Object>> limit, RedisClient.SortOrder sortAs, Format format, Parse<A> parse) {
        return SortedSetOps.zrangebyscore$(this, key, min, minInclusive, max, maxInclusive, limit, sortAs, format, parse);
    }

    @Override
    public <A> double zrangebyscore$default$2() {
        return SortedSetOps.zrangebyscore$default$2$(this);
    }

    @Override
    public <A> boolean zrangebyscore$default$3() {
        return SortedSetOps.zrangebyscore$default$3$(this);
    }

    @Override
    public <A> double zrangebyscore$default$4() {
        return SortedSetOps.zrangebyscore$default$4$(this);
    }

    @Override
    public <A> boolean zrangebyscore$default$5() {
        return SortedSetOps.zrangebyscore$default$5$(this);
    }

    @Override
    public <A> RedisClient.SortOrder zrangebyscore$default$7() {
        return SortedSetOps.zrangebyscore$default$7$(this);
    }

    @Override
    public <A> Option<List<Tuple2<A, Object>>> zrangebyscoreWithScore(Object key, double min, boolean minInclusive, double max, boolean maxInclusive, Option<Tuple2<Object, Object>> limit, RedisClient.SortOrder sortAs, Format format, Parse<A> parse) {
        return SortedSetOps.zrangebyscoreWithScore$(this, key, min, minInclusive, max, maxInclusive, limit, sortAs, format, parse);
    }

    @Override
    public <A> double zrangebyscoreWithScore$default$2() {
        return SortedSetOps.zrangebyscoreWithScore$default$2$(this);
    }

    @Override
    public <A> boolean zrangebyscoreWithScore$default$3() {
        return SortedSetOps.zrangebyscoreWithScore$default$3$(this);
    }

    @Override
    public <A> double zrangebyscoreWithScore$default$4() {
        return SortedSetOps.zrangebyscoreWithScore$default$4$(this);
    }

    @Override
    public <A> boolean zrangebyscoreWithScore$default$5() {
        return SortedSetOps.zrangebyscoreWithScore$default$5$(this);
    }

    @Override
    public <A> RedisClient.SortOrder zrangebyscoreWithScore$default$7() {
        return SortedSetOps.zrangebyscoreWithScore$default$7$(this);
    }

    @Override
    public Option<Object> zcount(Object key, double min, double max, boolean minInclusive, boolean maxInclusive, Format format) {
        return SortedSetOps.zcount$(this, key, min, max, minInclusive, maxInclusive, format);
    }

    @Override
    public double zcount$default$2() {
        return SortedSetOps.zcount$default$2$(this);
    }

    @Override
    public double zcount$default$3() {
        return SortedSetOps.zcount$default$3$(this);
    }

    @Override
    public boolean zcount$default$4() {
        return SortedSetOps.zcount$default$4$(this);
    }

    @Override
    public boolean zcount$default$5() {
        return SortedSetOps.zcount$default$5$(this);
    }

    @Override
    public Option<Object> zrank(Object key, Object member, boolean reverse, Format format) {
        return SortedSetOps.zrank$(this, key, member, reverse, format);
    }

    @Override
    public boolean zrank$default$3() {
        return SortedSetOps.zrank$default$3$(this);
    }

    @Override
    public Option<Object> zremrangebyrank(Object key, int start, int end, Format format) {
        return SortedSetOps.zremrangebyrank$(this, key, start, end, format);
    }

    @Override
    public int zremrangebyrank$default$2() {
        return SortedSetOps.zremrangebyrank$default$2$(this);
    }

    @Override
    public int zremrangebyrank$default$3() {
        return SortedSetOps.zremrangebyrank$default$3$(this);
    }

    @Override
    public Option<Object> zremrangebyscore(Object key, double start, double end, Format format) {
        return SortedSetOps.zremrangebyscore$(this, key, start, end, format);
    }

    @Override
    public double zremrangebyscore$default$2() {
        return SortedSetOps.zremrangebyscore$default$2$(this);
    }

    @Override
    public double zremrangebyscore$default$3() {
        return SortedSetOps.zremrangebyscore$default$3$(this);
    }

    @Override
    public Option<Object> zunionstore(Object dstKey, Iterable<Object> keys, RedisClient.Aggregate aggregate, Format format) {
        return SortedSetOps.zunionstore$(this, dstKey, keys, aggregate, format);
    }

    @Override
    public RedisClient.Aggregate zunionstore$default$3() {
        return SortedSetOps.zunionstore$default$3$(this);
    }

    @Override
    public Option<Object> zunionstoreWeighted(Object dstKey, Iterable<Product2<Object, Object>> kws, RedisClient.Aggregate aggregate, Format format) {
        return SortedSetOps.zunionstoreWeighted$(this, dstKey, kws, aggregate, format);
    }

    @Override
    public RedisClient.Aggregate zunionstoreWeighted$default$3() {
        return SortedSetOps.zunionstoreWeighted$default$3$(this);
    }

    @Override
    public Option<Object> zinterstore(Object dstKey, Iterable<Object> keys, RedisClient.Aggregate aggregate, Format format) {
        return SortedSetOps.zinterstore$(this, dstKey, keys, aggregate, format);
    }

    @Override
    public RedisClient.Aggregate zinterstore$default$3() {
        return SortedSetOps.zinterstore$default$3$(this);
    }

    @Override
    public Option<Object> zinterstoreWeighted(Object dstKey, Iterable<Product2<Object, Object>> kws, RedisClient.Aggregate aggregate, Format format) {
        return SortedSetOps.zinterstoreWeighted$(this, dstKey, kws, aggregate, format);
    }

    @Override
    public RedisClient.Aggregate zinterstoreWeighted$default$3() {
        return SortedSetOps.zinterstoreWeighted$default$3$(this);
    }

    @Override
    public <A> Option<List<A>> zrangebylex(Object key, String min, String max, Option<Tuple2<Object, Object>> limit, Format format, Parse<A> parse) {
        return SortedSetOps.zrangebylex$(this, key, min, max, limit, format, parse);
    }

    @Override
    public <A> Option<Tuple2<Option<Object>, Option<List<Option<A>>>>> zscan(Object key, int cursor, Object pattern, int count, Format format, Parse<A> parse) {
        return SortedSetOps.zscan$(this, key, cursor, pattern, count, format, parse);
    }

    @Override
    public <A> RedisClient.SortOrder zrange$default$4() {
        return SortedSetApi.zrange$default$4$(this);
    }

    @Override
    public <A> Object zscan$default$3() {
        return SortedSetApi.zscan$default$3$(this);
    }

    @Override
    public <A> int zscan$default$4() {
        return SortedSetApi.zscan$default$4$(this);
    }

    @Override
    public Option<Object> sadd(Object key, Object value, Seq<Object> values, Format format) {
        return SetOps.sadd$(this, key, value, values, format);
    }

    @Override
    public Option<Object> srem(Object key, Object value, Seq<Object> values, Format format) {
        return SetOps.srem$(this, key, value, values, format);
    }

    @Override
    public <A> Option<A> spop(Object key, Format format, Parse<A> parse) {
        return SetOps.spop$(this, key, format, parse);
    }

    @Override
    public Option<Object> smove(Object sourceKey, Object destKey, Object value, Format format) {
        return SetOps.smove$(this, sourceKey, destKey, value, format);
    }

    @Override
    public Option<Object> scard(Object key, Format format) {
        return SetOps.scard$(this, key, format);
    }

    @Override
    public boolean sismember(Object key, Object value, Format format) {
        return SetOps.sismember$(this, key, value, format);
    }

    @Override
    public <A> Option<Set<Option<A>>> sinter(Object key, Seq<Object> keys, Format format, Parse<A> parse) {
        return SetOps.sinter$(this, key, keys, format, parse);
    }

    @Override
    public Option<Object> sinterstore(Object key, Seq<Object> keys, Format format) {
        return SetOps.sinterstore$(this, key, keys, format);
    }

    @Override
    public <A> Option<Set<Option<A>>> sunion(Object key, Seq<Object> keys, Format format, Parse<A> parse) {
        return SetOps.sunion$(this, key, keys, format, parse);
    }

    @Override
    public Option<Object> sunionstore(Object key, Seq<Object> keys, Format format) {
        return SetOps.sunionstore$(this, key, keys, format);
    }

    @Override
    public <A> Option<Set<Option<A>>> sdiff(Object key, Seq<Object> keys, Format format, Parse<A> parse) {
        return SetOps.sdiff$(this, key, keys, format, parse);
    }

    @Override
    public Option<Object> sdiffstore(Object key, Seq<Object> keys, Format format) {
        return SetOps.sdiffstore$(this, key, keys, format);
    }

    @Override
    public <A> Option<Set<Option<A>>> smembers(Object key, Format format, Parse<A> parse) {
        return SetOps.smembers$(this, key, format, parse);
    }

    @Override
    public <A> Option<A> srandmember(Object key, Format format, Parse<A> parse) {
        return SetOps.srandmember$(this, key, format, parse);
    }

    @Override
    public <A> Option<List<Option<A>>> srandmember(Object key, int count, Format format, Parse<A> parse) {
        return SetOps.srandmember$(this, key, count, format, parse);
    }

    @Override
    public <A> Option<Set<Option<A>>> spop(Object key, int count, Format format, Parse<A> parse) {
        return SetOps.spop$(this, key, count, format, parse);
    }

    @Override
    public <A> Option<Tuple2<Option<Object>, Option<List<Option<A>>>>> sscan(Object key, int cursor, Object pattern, int count, Format format, Parse<A> parse) {
        return SetOps.sscan$(this, key, cursor, pattern, count, format, parse);
    }

    @Override
    public <A> Object sscan$default$3() {
        return SetApi.sscan$default$3$(this);
    }

    @Override
    public <A> int sscan$default$4() {
        return SetApi.sscan$default$4$(this);
    }

    @Override
    public Option<Object> lpush(Object key, Object value, Seq<Object> values, Format format) {
        return ListOps.lpush$(this, key, value, values, format);
    }

    @Override
    public Option<Object> rpush(Object key, Object value, Seq<Object> values, Format format) {
        return ListOps.rpush$(this, key, value, values, format);
    }

    @Override
    public Option<Object> llen(Object key, Format format) {
        return ListOps.llen$(this, key, format);
    }

    @Override
    public <A> Option<List<Option<A>>> lrange(Object key, int start, int end, Format format, Parse<A> parse) {
        return ListOps.lrange$(this, key, start, end, format, parse);
    }

    @Override
    public boolean ltrim(Object key, int start, int end, Format format) {
        return ListOps.ltrim$(this, key, start, end, format);
    }

    @Override
    public <A> Option<A> lindex(Object key, int index, Format format, Parse<A> parse) {
        return ListOps.lindex$(this, key, index, format, parse);
    }

    @Override
    public boolean lset(Object key, int index, Object value, Format format) {
        return ListOps.lset$(this, key, index, value, format);
    }

    @Override
    public Option<Object> lrem(Object key, int count, Object value, Format format) {
        return ListOps.lrem$(this, key, count, value, format);
    }

    @Override
    public <A> Option<A> lpop(Object key, Format format, Parse<A> parse) {
        return ListOps.lpop$(this, key, format, parse);
    }

    @Override
    public <A> Option<A> rpop(Object key, Format format, Parse<A> parse) {
        return ListOps.rpop$(this, key, format, parse);
    }

    @Override
    public <A> Option<A> rpoplpush(Object srcKey, Object dstKey, Format format, Parse<A> parse) {
        return ListOps.rpoplpush$(this, srcKey, dstKey, format, parse);
    }

    @Override
    public <A> Option<A> brpoplpush(Object srcKey, Object dstKey, int timeoutInSeconds, Format format, Parse<A> parse) {
        return ListOps.brpoplpush$(this, srcKey, dstKey, timeoutInSeconds, format, parse);
    }

    @Override
    public <K, V> Option<Tuple2<K, V>> blpop(int timeoutInSeconds, K key, Seq<K> keys, Format format, Parse<K> parseK, Parse<V> parseV) {
        return ListOps.blpop$(this, timeoutInSeconds, key, keys, format, parseK, parseV);
    }

    @Override
    public <K, V> Option<Tuple2<K, V>> brpop(int timeoutInSeconds, K key, Seq<K> keys, Format format, Parse<K> parseK, Parse<V> parseV) {
        return ListOps.brpop$(this, timeoutInSeconds, key, keys, format, parseK, parseV);
    }

    @Override
    public Option<Object> lpushx(Object key, Object value, Format format) {
        return ListOps.lpushx$(this, key, value, format);
    }

    @Override
    public Option<Object> rpushx(Object key, Object value, Format format) {
        return ListOps.rpushx$(this, key, value, format);
    }

    @Override
    public boolean set(Object key, Object value, StringApi.SetBehaviour whenSet, Duration expire, Format format) {
        return StringOps.set$(this, key, value, whenSet, expire, format);
    }

    @Override
    public StringApi.SetBehaviour set$default$3() {
        return StringOps.set$default$3$(this);
    }

    @Override
    public Duration set$default$4() {
        return StringOps.set$default$4$(this);
    }

    @Override
    public <A> Option<A> get(Object key, Format format, Parse<A> parse) {
        return StringOps.get$(this, key, format, parse);
    }

    @Override
    public <A> Option<A> getset(Object key, Object value, Format format, Parse<A> parse) {
        return StringOps.getset$(this, key, value, format, parse);
    }

    @Override
    public boolean setnx(Object key, Object value, Format format) {
        return StringOps.setnx$(this, key, value, format);
    }

    @Override
    public boolean setex(Object key, long expiry, Object value, Format format) {
        return StringOps.setex$(this, key, expiry, value, format);
    }

    @Override
    public boolean psetex(Object key, long expiryInMillis, Object value, Format format) {
        return StringOps.psetex$(this, key, expiryInMillis, value, format);
    }

    @Override
    public Option<Object> incr(Object key, Format format) {
        return StringOps.incr$(this, key, format);
    }

    @Override
    public Option<Object> incrby(Object key, long increment, Format format) {
        return StringOps.incrby$(this, key, increment, format);
    }

    @Override
    public Option<Object> incrbyfloat(Object key, float increment, Format format) {
        return StringOps.incrbyfloat$(this, key, increment, format);
    }

    @Override
    public Option<Object> decr(Object key, Format format) {
        return StringOps.decr$(this, key, format);
    }

    @Override
    public Option<Object> decrby(Object key, long increment, Format format) {
        return StringOps.decrby$(this, key, increment, format);
    }

    @Override
    public <A> Option<List<Option<A>>> mget(Object key, Seq<Object> keys, Format format, Parse<A> parse) {
        return StringOps.mget$(this, key, keys, format, parse);
    }

    @Override
    public boolean mset(Seq<Tuple2<Object, Object>> kvs, Format format) {
        return StringOps.mset$(this, kvs, format);
    }

    @Override
    public boolean msetnx(Seq<Tuple2<Object, Object>> kvs, Format format) {
        return StringOps.msetnx$(this, kvs, format);
    }

    @Override
    public Option<Object> setrange(Object key, int offset, Object value, Format format) {
        return StringOps.setrange$(this, key, offset, value, format);
    }

    @Override
    public <A> Option<A> getrange(Object key, int start, int end, Format format, Parse<A> parse) {
        return StringOps.getrange$(this, key, start, end, format, parse);
    }

    @Override
    public Option<Object> strlen(Object key, Format format) {
        return StringOps.strlen$(this, key, format);
    }

    @Override
    public Option<Object> append(Object key, Object value, Format format) {
        return StringOps.append$(this, key, value, format);
    }

    @Override
    public Option<Object> getbit(Object key, int offset, Format format) {
        return StringOps.getbit$(this, key, offset, format);
    }

    @Override
    public Option<Object> setbit(Object key, int offset, Object value, Format format) {
        return StringOps.setbit$(this, key, offset, value, format);
    }

    @Override
    public Option<Object> bitop(String op, Object destKey, Seq<Object> srcKeys, Format format) {
        return StringOps.bitop$(this, op, destKey, srcKeys, format);
    }

    @Override
    public Option<Object> bitcount(Object key, Option<Tuple2<Object, Object>> range, Format format) {
        return StringOps.bitcount$(this, key, range, format);
    }

    @Override
    public boolean set(Object key, Object value, boolean onlyIfExists, package.SecondsOrMillis time) {
        return StringApi.set$(this, key, value, onlyIfExists, time);
    }

    @Override
    public Option<Tuple2<Object, Object>> bitcount$default$2() {
        return StringApi.bitcount$default$2$(this);
    }

    @Override
    public boolean save() {
        return NodeOps.save$(this);
    }

    @Override
    public boolean bgsave() {
        return NodeOps.bgsave$(this);
    }

    @Override
    public boolean shutdown() {
        return NodeOps.shutdown$(this);
    }

    @Override
    public boolean bgrewriteaof() {
        return NodeOps.bgrewriteaof$(this);
    }

    @Override
    public Option<Object> lastsave() {
        return NodeOps.lastsave$(this);
    }

    @Override
    public Option<String> info() {
        return NodeOps.info$(this);
    }

    @Override
    public boolean monitor() {
        return NodeOps.monitor$(this);
    }

    @Override
    public boolean slaveof(Object options) {
        return NodeOps.slaveof$(this, options);
    }

    @Override
    public <A> Option<List<Option<A>>> keys(Object pattern, Format format, Parse<A> parse) {
        return BaseOps.keys$(this, pattern, format, parse);
    }

    @Override
    public boolean rename(Object oldkey, Object newkey, Format format) {
        return BaseOps.rename$(this, oldkey, newkey, format);
    }

    @Override
    public boolean renamenx(Object oldkey, Object newkey, Format format) {
        return BaseOps.renamenx$(this, oldkey, newkey, format);
    }

    @Override
    public Option<Object> dbsize() {
        return BaseOps.dbsize$(this);
    }

    @Override
    public boolean exists(Object key, Format format) {
        return BaseOps.exists$(this, key, format);
    }

    @Override
    public Option<Object> del(Object key, Seq<Object> keys, Format format) {
        return BaseOps.del$(this, key, keys, format);
    }

    @Override
    public Option<String> getType(Object key, Format format) {
        return BaseOps.getType$(this, key, format);
    }

    @Override
    public boolean expire(Object key, int ttl, Format format) {
        return BaseOps.expire$(this, key, ttl, format);
    }

    @Override
    public boolean pexpire(Object key, int ttlInMillis, Format format) {
        return BaseOps.pexpire$(this, key, ttlInMillis, format);
    }

    @Override
    public boolean expireat(Object key, long timestamp, Format format) {
        return BaseOps.expireat$(this, key, timestamp, format);
    }

    @Override
    public boolean pexpireat(Object key, long timestampInMillis, Format format) {
        return BaseOps.pexpireat$(this, key, timestampInMillis, format);
    }

    @Override
    public Option<Object> ttl(Object key, Format format) {
        return BaseOps.ttl$(this, key, format);
    }

    @Override
    public Option<Object> pttl(Object key, Format format) {
        return BaseOps.pttl$(this, key, format);
    }

    @Override
    public boolean flushdb() {
        return BaseOps.flushdb$(this);
    }

    @Override
    public boolean flushall() {
        return BaseOps.flushall$(this);
    }

    @Override
    public boolean quit() {
        return BaseOps.quit$(this);
    }

    @Override
    public <A> Option<List<Option<A>>> time(Format format, Parse<A> parse) {
        return BaseOps.time$(this, format, parse);
    }

    @Override
    public <A> Option<A> randomkey(Parse<A> parse) {
        return BaseOps.randomkey$(this, parse);
    }

    @Override
    public boolean select(int index) {
        return BaseOps.select$(this, index);
    }

    @Override
    public boolean move(Object key, int db, Format format) {
        return BaseOps.move$(this, key, db, format);
    }

    @Override
    public boolean auth(Object secret, Format format) {
        return BaseOps.auth$(this, secret, format);
    }

    @Override
    public boolean persist(Object key, Format format) {
        return BaseOps.persist$(this, key, format);
    }

    @Override
    public <A> Option<Tuple2<Option<Object>, Option<List<Option<A>>>>> scan(int cursor, Object pattern, int count, Format format, Parse<A> parse) {
        return BaseOps.scan$(this, cursor, pattern, count, format, parse);
    }

    @Override
    public Option<String> ping() {
        return BaseOps.ping$(this);
    }

    @Override
    public boolean watch(Object key, Seq<Object> keys, Format format) {
        return BaseOps.watch$(this, key, keys, format);
    }

    @Override
    public boolean unwatch() {
        return BaseOps.unwatch$(this);
    }

    @Override
    public Option<Map<String, Option<String>>> getConfig(Object key, Format format) {
        return BaseOps.getConfig$(this, key, format);
    }

    @Override
    public Option<String> setConfig(Object key, Object value, Format format) {
        return BaseOps.setConfig$(this, key, value, format);
    }

    @Override
    public <A> Option<List<Option<A>>> sort(String key, Option<Tuple2<Object, Object>> limit, boolean desc, boolean alpha, Option<String> by, List<String> get, Format format, Parse<A> parse) {
        return BaseOps.sort$(this, key, limit, desc, alpha, by, get, format, parse);
    }

    @Override
    public <A> Option<Object> sortNStore(String key, Option<Tuple2<Object, Object>> limit, boolean desc, boolean alpha, Option<String> by, List<String> get, String storeAt, Format format, Parse<A> parse) {
        return BaseOps.sortNStore$(this, key, limit, desc, alpha, by, get, storeAt, format, parse);
    }

    @Override
    public <A> Option<Tuple2<Object, Object>> sort$default$2() {
        return BaseApi.sort$default$2$(this);
    }

    @Override
    public <A> boolean sort$default$3() {
        return BaseApi.sort$default$3$(this);
    }

    @Override
    public <A> boolean sort$default$4() {
        return BaseApi.sort$default$4$(this);
    }

    @Override
    public <A> Option<String> sort$default$5() {
        return BaseApi.sort$default$5$(this);
    }

    @Override
    public <A> List<String> sort$default$6() {
        return BaseApi.sort$default$6$(this);
    }

    @Override
    public <A> Option<Tuple2<Object, Object>> sortNStore$default$2() {
        return BaseApi.sortNStore$default$2$(this);
    }

    @Override
    public <A> boolean sortNStore$default$3() {
        return BaseApi.sortNStore$default$3$(this);
    }

    @Override
    public <A> boolean sortNStore$default$4() {
        return BaseApi.sortNStore$default$4$(this);
    }

    @Override
    public <A> Option<String> sortNStore$default$5() {
        return BaseApi.sortNStore$default$5$(this);
    }

    @Override
    public <A> List<String> sortNStore$default$6() {
        return BaseApi.sortNStore$default$6$(this);
    }

    @Override
    public <A> Object keys$default$1() {
        return BaseApi.keys$default$1$(this);
    }

    @Override
    public <A> Object scan$default$2() {
        return BaseApi.scan$default$2$(this);
    }

    @Override
    public <A> int scan$default$3() {
        return BaseApi.scan$default$3$(this);
    }

    @Override
    public Object getConfig$default$1() {
        return BaseApi.getConfig$default$1$(this);
    }

    @Override
    public <T> T processForKey(Object key, Function1<RedisCommand, T> body, Format format) {
        return (T)RedisClusterOps.processForKey$(this, key, body, format);
    }

    @Override
    public <T> Iterable<T> processForKeys(List<Object> keys, Function1<List<Object>, Function1<RedisCommand, T>> body, Format format) {
        return RedisClusterOps.processForKeys$(this, keys, body, format);
    }

    @Override
    public <T> T inSameNode(Seq<Object> keys, Function1<RedisClient, T> body, Format format) {
        return (T)RedisClusterOps.inSameNode$(this, keys, body, format);
    }

    @Override
    public Some<Object> com$redis$cluster$EvalOps$$scriptExistsNot() {
        return this.com$redis$cluster$EvalOps$$scriptExistsNot;
    }

    @Override
    public final void com$redis$cluster$EvalOps$_setter_$com$redis$cluster$EvalOps$$scriptExistsNot_$eq(Some<Object> x$1) {
        this.com$redis$cluster$EvalOps$$scriptExistsNot = x$1;
    }

    @Override
    public Option<String> pong() {
        return this.pong;
    }

    @Override
    public void com$redis$api$BaseApi$_setter_$pong_$eq(Option<String> x$1) {
        this.pong = x$1;
    }

    @Override
    public Random r() {
        return this.r;
    }

    @Override
    public int POINTS_PER_SERVER() {
        return this.POINTS_PER_SERVER;
    }

    @Override
    public void com$redis$cluster$RedisClusterOps$_setter_$r_$eq(Random x$1) {
        this.r = x$1;
    }

    @Override
    public void com$redis$cluster$RedisClusterOps$_setter_$POINTS_PER_SERVER_$eq(int x$1) {
        this.POINTS_PER_SERVER = x$1;
    }

    public List<package.ClusterNode> hosts() {
        return this.hosts;
    }

    @Override
    public Option<KeyTag> keyTag() {
        return this.keyTag;
    }

    public List<package.IdentifiableRedisClientPool> clients() {
        return this.clients;
    }

    @Override
    public HashRing<package.IdentifiableRedisClientPool> hr() {
        return this.hr;
    }

    @Override
    public package.IdentifiableRedisClientPool nodeForKey(Object key, Format format) {
        byte[] bKey = format.apply(key);
        return this.hr().getNode((Seq<Object>)((Seq)this.keyTag().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.tag((Seq<Object>)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bKey)).toIndexedSeq())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bKey)).toIndexedSeq())));
    }

    @Override
    public Try<BoxedUnit> addServer(package.ClusterNode server) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            package.IdentifiableRedisClientPool instance = new package.IdentifiableRedisClientPool(server);
            Object t = instance.withClient((Function1 & Serializable & scala.Serializable)x$2 -> x$2.ping());
            Option<String> option = this.pong();
            return !(t != null ? !t.equals(option) : option != null) ? new Success((Object)instance) : new Failure(new Throwable(new StringBuilder(23).append("Ping method failed for ").append(server).toString()));
        }).flatten(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)i -> {
            RedisCluster.$anonfun$addServer$3(this, i);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void replaceServer(package.ClusterNode server) {
        Option<package.IdentifiableRedisClientPool> option = this.hr().replaceNode(new package.IdentifiableRedisClientPool(server));
        if (option instanceof Some) {
            Some some = (Some)option;
            package.IdentifiableRedisClientPool clientPool = (package.IdentifiableRedisClientPool)some.value();
            clientPool.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public void removeServer(String nodename) {
        Option option = this.hr().cluster().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RedisCluster.$anonfun$removeServer$1(nodename, x$3)));
        if (option instanceof Some) {
            Some some = (Some)option;
            package.IdentifiableRedisClientPool pool = (package.IdentifiableRedisClientPool)some.value();
            this.hr().removeNode(pool);
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> pool.close());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Override
    public List<package.ClusterNode> listServers() {
        return ((IndexedSeqOptimized)this.hr().cluster().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.node(), ArrayBuffer$.MODULE$.canBuildFrom())).toList();
    }

    @Override
    public <T> Iterable<T> onAllConns(Function1<RedisClient, T> body) {
        return (Iterable)this.hr().cluster().map((Function1 & Serializable & scala.Serializable)p -> p.withClient((Function1 & Serializable & scala.Serializable)client -> body.apply(client)), ArrayBuffer$.MODULE$.canBuildFrom());
    }

    @Override
    public void close() {
        this.hr().cluster().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public RedisClientPool randomNode() {
        int rni = this.r().nextInt(this.hr().cluster().size());
        return (RedisClientPool)this.hr().cluster().apply(rni);
    }

    public static final /* synthetic */ void $anonfun$addServer$3(RedisCluster $this, package.IdentifiableRedisClientPool i) {
        $this.hr().addNode(i);
    }

    public static final /* synthetic */ boolean $anonfun$removeServer$1(String nodename$1, package.IdentifiableRedisClientPool x$3) {
        return x$3.node().nodename().equals(nodename$1);
    }

    public RedisCluster(List<package.ClusterNode> hosts, Option<KeyTag> keyTag) {
        this.hosts = hosts;
        this.keyTag = keyTag;
        RedisClusterOps.$init$(this);
        BaseApi.$init$(this);
        BaseOps.$init$(this);
        NodeOps.$init$(this);
        StringApi.$init$(this);
        StringOps.$init$(this);
        ListOps.$init$(this);
        SetOps.$init$(this);
        SortedSetOps.$init$(this);
        EvalOps.$init$(this);
        HashOps.$init$(this);
        this.clients = (List)hosts.map((Function1 & Serializable & scala.Serializable)h -> new package.IdentifiableRedisClientPool((package.ClusterNode)h), List$.MODULE$.canBuildFrom());
        this.hr = new HashRing<package.IdentifiableRedisClientPool>(this.clients(), this.POINTS_PER_SERVER());
    }
}

