/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus.config;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.config.IBusConfiguration;
import net.engio.mbassy.listener.MetadataReader;
import net.engio.mbassy.subscription.ISubscriptionManagerProvider;
import net.engio.mbassy.subscription.SubscriptionFactory;
import net.engio.mbassy.subscription.SubscriptionManagerProvider;

public class BusConfiguration
implements IBusConfiguration {
    protected static final ThreadFactory AsynchronousHandlerThreadFactory = new ThreadFactory(){
        private final AtomicInteger threadID = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("AsyncHandler-" + this.threadID.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    };
    protected static final ThreadFactory DispatcherThreadFactory = new ThreadFactory(){
        private final AtomicInteger threadID = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            thread.setName("Dispatcher-" + this.threadID.getAndIncrement());
            return thread;
        }
    };
    protected int numberOfMessageDispatchers;
    protected ExecutorService executor;
    protected SubscriptionFactory subscriptionFactory;
    protected MetadataReader metadataReader;
    protected MessagePublication.Factory messagePublicationFactory;
    protected ThreadFactory dispatcherThreadFactory;
    protected ISubscriptionManagerProvider subscriptionManagerProvider;
    protected BlockingQueue<MessagePublication> pendingMessagesQueue;

    public static BusConfiguration Default() {
        return BusConfiguration.Default(2);
    }

    public static BusConfiguration Default(int numberOfDispatchers) {
        int numberOfCoreThreads = Runtime.getRuntime().availableProcessors();
        return BusConfiguration.Default(numberOfDispatchers, numberOfCoreThreads, numberOfCoreThreads * 2);
    }

    public static BusConfiguration Default(int numberOfDispatchers, int initialCoreThreads, int maximumCoreThreads) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(initialCoreThreads, maximumCoreThreads, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), AsynchronousHandlerThreadFactory);
        return BusConfiguration.Default(numberOfDispatchers, executor);
    }

    public static BusConfiguration Default(int numberOfDispatchers, ThreadPoolExecutor executor) {
        BusConfiguration defaultConfig = new BusConfiguration();
        defaultConfig.setExecutorForAsynchronousHandlers(executor);
        defaultConfig.setMetadataReader(new MetadataReader());
        defaultConfig.setSubscriptionFactory(new SubscriptionFactory());
        defaultConfig.setNumberOfMessageDispatchers(numberOfDispatchers);
        defaultConfig.setMessagePublicationFactory(new MessagePublication.Factory());
        defaultConfig.setPendingMessagesQueue(new LinkedBlockingQueue<MessagePublication>(Integer.MAX_VALUE));
        defaultConfig.setThreadFactoryForAsynchronousMessageDispatch(DispatcherThreadFactory);
        defaultConfig.setSubscriptionManagerProvider(new SubscriptionManagerProvider());
        return defaultConfig;
    }

    public static BusConfiguration Empty() {
        return new BusConfiguration();
    }

    public void setPendingMessagesQueue(BlockingQueue<MessagePublication> pendingMessagesQueue) {
        this.pendingMessagesQueue = pendingMessagesQueue;
    }

    private BusConfiguration() {
    }

    @Override
    public int getNumberOfMessageDispatchers() {
        return this.numberOfMessageDispatchers > 0 ? this.numberOfMessageDispatchers : 2;
    }

    public BusConfiguration setNumberOfMessageDispatchers(int numberOfMessageDispatchers) {
        this.numberOfMessageDispatchers = numberOfMessageDispatchers;
        return this;
    }

    @Override
    public ExecutorService getExecutorForAsynchronousHandlers() {
        return this.executor;
    }

    @Override
    public BlockingQueue<MessagePublication> getPendingMessagesQueue() {
        return new LinkedBlockingQueue<MessagePublication>(Integer.MAX_VALUE);
    }

    @Override
    public ThreadFactory getThreadFactoryForAsynchronousMessageDispatch() {
        return this.dispatcherThreadFactory;
    }

    public BusConfiguration setThreadFactoryForAsynchronousMessageDispatch(ThreadFactory factory) {
        this.dispatcherThreadFactory = factory;
        return this;
    }

    public BusConfiguration setExecutorForAsynchronousHandlers(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public MessagePublication.Factory getMessagePublicationFactory() {
        return this.messagePublicationFactory;
    }

    public BusConfiguration setMessagePublicationFactory(MessagePublication.Factory messagePublicationFactory) {
        this.messagePublicationFactory = messagePublicationFactory;
        return this;
    }

    @Override
    public MetadataReader getMetadataReader() {
        return this.metadataReader;
    }

    public BusConfiguration setMetadataReader(MetadataReader metadataReader) {
        this.metadataReader = metadataReader;
        return this;
    }

    @Override
    public SubscriptionFactory getSubscriptionFactory() {
        return this.subscriptionFactory;
    }

    public BusConfiguration setSubscriptionFactory(SubscriptionFactory subscriptionFactory) {
        this.subscriptionFactory = subscriptionFactory;
        return this;
    }

    @Override
    public ISubscriptionManagerProvider getSubscriptionManagerProvider() {
        return this.subscriptionManagerProvider;
    }

    public BusConfiguration setSubscriptionManagerProvider(ISubscriptionManagerProvider subscriptionManagerProvider) {
        this.subscriptionManagerProvider = subscriptionManagerProvider;
        return this;
    }
}

