/*
 * Decompiled with CFR 0.152.
 */
package net.jadler.junit.rule;

import java.nio.charset.Charset;
import net.jadler.Jadler;
import net.jadler.JadlerConfiguration;
import net.jadler.KeyValues;
import net.jadler.stubbing.server.StubHttpServer;
import org.apache.commons.lang.Validate;
import org.junit.rules.ExternalResource;

public class JadlerRule
extends ExternalResource
implements JadlerConfiguration {
    private static final int DEFAULT_PORT = -1;
    private final int port;
    private final StubHttpServer server;
    private String defaultContentType;
    private Charset defaultEncoding;
    private int defaultStatus = -1;
    private boolean skipsRequestsRecording = false;
    private KeyValues defaultHeaders = KeyValues.EMPTY;

    public JadlerRule() {
        this.port = -1;
        this.server = null;
    }

    public JadlerRule(int port) {
        Validate.isTrue((port > 0 ? 1 : 0) != 0, (String)"port must be an integer bigger than 0");
        this.port = port;
        this.server = null;
    }

    public JadlerRule(StubHttpServer server) {
        Validate.notNull((Object)server, (String)"server cannot be null");
        this.port = -1;
        this.server = server;
    }

    protected void before() {
        Jadler.OngoingConfiguration conf = this.port == -1 ? (this.server == null ? Jadler.initJadler() : Jadler.initJadlerUsing((StubHttpServer)this.server)) : Jadler.initJadlerListeningOn((int)this.port);
        if (this.defaultContentType != null) {
            conf.withDefaultResponseContentType(this.defaultContentType);
        }
        if (this.defaultEncoding != null) {
            conf.withDefaultResponseEncoding(this.defaultEncoding);
        }
        if (this.defaultStatus > -1) {
            conf.withDefaultResponseStatus(this.defaultStatus);
        }
        for (String name : this.defaultHeaders.getKeys()) {
            for (String value : this.defaultHeaders.getValues(name)) {
                conf.withDefaultResponseHeader(name, value);
            }
        }
        if (this.skipsRequestsRecording) {
            conf.withRequestsRecordingDisabled();
        }
    }

    protected void after() {
        Jadler.closeJadler();
    }

    public JadlerRule withDefaultResponseContentType(String defaultContentType) {
        this.defaultContentType = defaultContentType;
        return this;
    }

    public JadlerRule withDefaultResponseEncoding(Charset defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    public JadlerRule withDefaultResponseHeader(String name, String value) {
        this.defaultHeaders = this.defaultHeaders.add(name, value);
        return this;
    }

    public JadlerRule withDefaultResponseStatus(int defaultStatus) {
        this.defaultStatus = defaultStatus;
        return this;
    }

    public JadlerRule withRequestsRecordingDisabled() {
        this.skipsRequestsRecording = true;
        return this;
    }
}

