/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Duration;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;

public abstract class AbstractSimpleLock
implements SimpleLock {
    private boolean valid = true;
    protected final LockConfiguration lockConfiguration;

    protected AbstractSimpleLock(LockConfiguration lockConfiguration) {
        this.lockConfiguration = lockConfiguration;
    }

    @Override
    public final void unlock() {
        this.checkValidity();
        this.doUnlock();
        this.valid = false;
    }

    protected abstract void doUnlock();

    @Override
    public Optional<SimpleLock> extend(Duration lockAtMostFor, Duration lockAtLeastFor) {
        this.checkValidity();
        Optional<SimpleLock> result = this.doExtend(new LockConfiguration(ClockProvider.now(), this.lockConfiguration.getName(), lockAtMostFor, lockAtLeastFor));
        this.valid = false;
        return result;
    }

    protected Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
        throw new UnsupportedOperationException();
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new IllegalStateException("Lock " + this.lockConfiguration.getName() + " is not valid, it has already been unlocked or extended");
        }
    }
}

