/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import java.time.Duration;
import net.javacrumbs.shedlock.spring.ExtendedLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.aop.AbstractLockConfiguration;
import net.javacrumbs.shedlock.spring.aop.SpringLockConfigurationExtractor;
import net.javacrumbs.shedlock.spring.aop.StringToDurationConverter;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringValueResolver;

@Configuration
class LockConfigurationExtractorConfiguration
extends AbstractLockConfiguration
implements EmbeddedValueResolverAware {
    private final StringToDurationConverter durationConverter = StringToDurationConverter.INSTANCE;
    private StringValueResolver resolver;

    LockConfigurationExtractorConfiguration() {
    }

    @Bean
    ExtendedLockConfigurationExtractor lockConfigurationExtractor() {
        return new SpringLockConfigurationExtractor(this.defaultLockAtMostForDuration(), this.defaultLockAtLeastForDuration(), this.resolver, this.durationConverter);
    }

    private Duration defaultLockAtLeastForDuration() {
        return this.toDuration(this.getDefaultLockAtLeastFor());
    }

    private Duration defaultLockAtMostForDuration() {
        return this.toDuration(this.getDefaultLockAtMostFor());
    }

    private String getDefaultLockAtLeastFor() {
        return this.getStringFromAnnotation("defaultLockAtLeastFor");
    }

    private String getDefaultLockAtMostFor() {
        return this.getStringFromAnnotation("defaultLockAtMostFor");
    }

    private Duration toDuration(String string) {
        return this.durationConverter.convert(this.resolver.resolveStringValue(string));
    }

    protected String getStringFromAnnotation(String name) {
        return this.annotationAttributes.getString(name);
    }

    public void setEmbeddedValueResolver(@NonNull StringValueResolver resolver) {
        this.resolver = resolver;
    }
}

