/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.spring.aop;

import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockableRunnable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.NameMatchMethodPointcut;
import org.springframework.aop.support.RootClassFilter;
import org.springframework.scheduling.TaskScheduler;

class SchedulerProxyScheduledLockAdvisor
extends AbstractPointcutAdvisor {
    private final Pointcut pointcut = new TaskSchedulerPointcut();
    private final Advice advice;
    private static final Logger logger = LoggerFactory.getLogger(SchedulerProxyScheduledLockAdvisor.class);

    SchedulerProxyScheduledLockAdvisor(LockManager lockManager) {
        this.advice = new LockingInterceptor(lockManager);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    private static class TaskSchedulerPointcut
    implements Pointcut {
        private TaskSchedulerPointcut() {
        }

        public ClassFilter getClassFilter() {
            return new RootClassFilter(TaskScheduler.class);
        }

        public MethodMatcher getMethodMatcher() {
            NameMatchMethodPointcut nameMatchMethodPointcut = new NameMatchMethodPointcut();
            nameMatchMethodPointcut.setMappedNames(new String[]{"schedule", "scheduleAtFixedRate", "scheduleWithFixedDelay"});
            return nameMatchMethodPointcut;
        }
    }

    private static class LockingInterceptor
    implements MethodInterceptor {
        private final LockManager lockManager;

        private LockingInterceptor(LockManager lockManager) {
            this.lockManager = lockManager;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object[] arguments = invocation.getArguments();
            if (arguments.length >= 1 && arguments[0] instanceof Runnable) {
                arguments[0] = new LockableRunnable((Runnable)arguments[0], this.lockManager);
            } else {
                logger.warn("Task scheduler first argument should be Runnable");
            }
            return invocation.proceed();
        }
    }
}

