/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal.executor;

import java.time.Duration;
import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.CircuitBreakerOpenException;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.PolicyExecutor;

public class CircuitBreakerExecutor
extends PolicyExecutor<CircuitBreaker> {
    public CircuitBreakerExecutor(CircuitBreaker circuitBreaker) {
        super(circuitBreaker);
    }

    @Override
    protected ExecutionResult preExecute() {
        if (((CircuitBreaker)this.policy).allowsExecution()) {
            ((CircuitBreaker)this.policy).preExecute();
            return null;
        }
        return ExecutionResult.failure(new CircuitBreakerOpenException());
    }

    @Override
    protected boolean isFailure(ExecutionResult result) {
        long elapsedNanos = this.execution.getElapsedTime().toNanos();
        Duration timeout = ((CircuitBreaker)this.policy).getTimeout();
        boolean timeoutExceeded = timeout != null && elapsedNanos >= timeout.toNanos();
        return timeoutExceeded || super.isFailure(result);
    }

    @Override
    protected void onSuccess(ExecutionResult result) {
        ((CircuitBreaker)this.policy).recordSuccess();
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        ((CircuitBreaker)this.policy).recordFailure();
        return result.withComplete();
    }
}

