/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal.executor;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.FailsafeFuture;
import net.jodah.failsafe.Fallback;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.util.concurrent.Scheduler;

public class FallbackExecutor
extends PolicyExecutor<Fallback> {
    public FallbackExecutor(Fallback fallback) {
        super(fallback);
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        try {
            return result.withResult(((Fallback)this.policy).apply(result.getResult(), result.getFailure(), this.execution.copy()));
        }
        catch (Exception e) {
            return ExecutionResult.failure(e);
        }
    }

    @Override
    protected CompletableFuture<ExecutionResult> onFailureAsync(ExecutionResult result, Scheduler scheduler, FailsafeFuture<Object> future) {
        if (!((Fallback)this.policy).isAsync()) {
            return CompletableFuture.completedFuture(this.onFailure(result));
        }
        CompletableFuture<ExecutionResult> promise = new CompletableFuture<ExecutionResult>();
        Callable<Object> callable = () -> promise.complete(this.onFailure(result));
        try {
            future.inject(scheduler.schedule(callable, result.getWaitNanos(), TimeUnit.NANOSECONDS));
        }
        catch (Exception e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }
}

