/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.internal.util.Unchecked;
import net.jodah.failsafe.util.concurrent.Scheduler;

public final class CommonPoolScheduler
implements Scheduler {
    public static final CommonPoolScheduler INSTANCE = new CommonPoolScheduler();
    private static final ExecutorService commonPool = ForkJoinPool.commonPool();
    private static volatile ScheduledExecutorService delayer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ScheduledExecutorService delayer() {
        if (delayer != null) return delayer;
        Class<CommonPoolScheduler> clazz = CommonPoolScheduler.class;
        synchronized (CommonPoolScheduler.class) {
            if (delayer != null) return delayer;
            delayer = new ScheduledThreadPoolExecutor(1, new DelayerThreadFactory());
            // ** MonitorExit[var0] (shouldn't be in output)
            return delayer;
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Callable<?> callable, long delay, TimeUnit unit) {
        Executor executor = delay == 0L ? commonPool : new DelayedExecutor(delay, unit, commonPool);
        CompletableFuture<?> future = CompletableFuture.supplyAsync(Unchecked.supplier(callable), executor);
        return new ScheduledCompletableFuture(future, delay, unit);
    }

    static final class ScheduledCompletableFuture<V>
    implements ScheduledFuture<V> {
        private final CompletableFuture<V> delegate;
        private final long time;

        ScheduledCompletableFuture(CompletableFuture<V> delegate, long delay, TimeUnit unit) {
            this.time = System.nanoTime() + unit.toNanos(delay);
            this.delegate = Assert.notNull(delegate, "delegate");
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof ScheduledCompletableFuture) {
                return Long.compare(this.time, ((ScheduledCompletableFuture)other).time);
            }
            return Long.compare(this.getDelay(TimeUnit.NANOSECONDS), other.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }
    }

    static final class DelayedExecutor
    implements Executor {
        final long delay;
        final TimeUnit unit;
        final Executor executor;

        DelayedExecutor(long delay, TimeUnit unit, Executor executor) {
            this.delay = delay;
            this.unit = unit;
            this.executor = executor;
        }

        @Override
        public void execute(Runnable runnable) {
            CommonPoolScheduler.delayer().schedule(() -> commonPool.execute(runnable), this.delay, this.unit);
        }
    }

    static final class DelayerThreadFactory
    implements ThreadFactory {
        DelayerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("FailsafeDelayScheduler");
            return t;
        }
    }
}

