/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jaudiotagger.audio.dff.ChnlChunk;
import org.jaudiotagger.audio.dff.CmprChunk;
import org.jaudiotagger.audio.dff.DffChunkType;
import org.jaudiotagger.audio.dff.DstChunk;
import org.jaudiotagger.audio.dff.EndChunk;
import org.jaudiotagger.audio.dff.FrteChunk;
import org.jaudiotagger.audio.dff.FsChunk;
import org.jaudiotagger.audio.dff.Id3Chunk;
import org.jaudiotagger.audio.exceptions.InvalidChunkException;
import org.jaudiotagger.audio.generic.Utils;

public class BaseChunk {
    public static final int ID_LENGHT = 4;
    private Long chunkSize;
    private Long chunkStart;

    public static BaseChunk readIdChunk(ByteBuffer dataBuffer) throws InvalidChunkException {
        String type = Utils.readFourBytesAsChars(dataBuffer);
        if (DffChunkType.FS.getCode().equals(type)) {
            return new FsChunk(dataBuffer);
        }
        if (DffChunkType.CHNL.getCode().equals(type)) {
            return new ChnlChunk(dataBuffer);
        }
        if (DffChunkType.CMPR.getCode().equals(type)) {
            return new CmprChunk(dataBuffer);
        }
        if (DffChunkType.END.getCode().equals(type) || DffChunkType.DSD.getCode().equals(type)) {
            return new EndChunk(dataBuffer);
        }
        if (DffChunkType.DST.getCode().equals(type)) {
            return new DstChunk(dataBuffer);
        }
        if (DffChunkType.FRTE.getCode().equals(type)) {
            return new FrteChunk(dataBuffer);
        }
        if (DffChunkType.ID3.getCode().equals(type)) {
            return new Id3Chunk(dataBuffer);
        }
        throw new InvalidChunkException(type + " is not recognized as a valid DFF chunk");
    }

    protected BaseChunk(ByteBuffer dataBuffer) {
    }

    protected void readDataChunch(FileChannel fc) throws IOException {
        ByteBuffer audioData = Utils.readFileDataIntoBufferLE(fc, 8);
        this.chunkSize = Long.reverseBytes(audioData.getLong());
        this.chunkStart = fc.position();
    }

    protected void skipToChunkEnd(FileChannel fc) throws IOException {
        Long skip = this.getChunkEnd() - fc.position();
        if (skip > 0L) {
            Utils.readFileDataIntoBufferLE(fc, skip.intValue());
        }
    }

    public Long getChunkStart() {
        return this.chunkStart;
    }

    public Long getChunkSize() {
        return this.chunkSize;
    }

    public Long getChunkEnd() {
        return this.chunkStart + this.chunkSize;
    }
}

