/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.util.HashMap;
import java.util.Map;

public enum DffChunkType {
    FRM8("FRM8"),
    DSD("DSD "),
    PROP("PROP"),
    SND("SND "),
    FS("FS  "),
    CHNL("CHNL"),
    CMPR("CMPR"),
    DITI("DITI"),
    END("DSD "),
    DST("DST "),
    FRTE("FRTE"),
    ID3("ID3 "),
    DATA("data");

    private static final Map<String, DffChunkType> CODE_TYPE_MAP;
    private String code;

    private DffChunkType(String code) {
        this.code = code;
    }

    public static synchronized DffChunkType get(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (DffChunkType type : DffChunkType.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, DffChunkType>();
    }
}

