/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import org.jaudiotagger.audio.AudioHeader;

public class GenericAudioHeader
implements AudioHeader {
    private Long audioDataLength;
    private Long audioDataStartPosition;
    private Long audioDataEndPosition;
    private Integer bitRate;
    private Integer noOfChannels;
    private Integer samplingRate;
    private Integer bitsPerSample;
    private String encodingType;
    private String format;
    private Boolean isVbr = Boolean.TRUE;
    private Boolean isLossless;
    private Double trackLength;
    private Long noOfSamples;
    private Integer byteRate;

    @Override
    public String getBitRate() {
        return String.valueOf(this.bitRate);
    }

    @Override
    public long getBitRateAsNumber() {
        return this.bitRate.intValue();
    }

    public int getChannelNumber() {
        return this.noOfChannels;
    }

    @Override
    public String getChannels() {
        return String.valueOf(this.getChannelNumber());
    }

    @Override
    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public int getTrackLength() {
        return (int)Math.round(this.getPreciseTrackLength());
    }

    @Override
    public double getPreciseTrackLength() {
        return this.trackLength;
    }

    @Override
    public String getSampleRate() {
        return String.valueOf(this.samplingRate);
    }

    @Override
    public int getSampleRateAsNumber() {
        return this.samplingRate;
    }

    @Override
    public int getBitsPerSample() {
        if (this.bitsPerSample == null) {
            return -1;
        }
        return this.bitsPerSample;
    }

    @Override
    public boolean isVariableBitRate() {
        if (this.isVbr == null) {
            return false;
        }
        return this.isVbr;
    }

    @Override
    public boolean isLossless() {
        if (this.isLossless == null) {
            return false;
        }
        return this.isLossless;
    }

    public void setBitRate(int bitRate) {
        this.bitRate = bitRate;
    }

    public void setChannelNumber(int channelMode) {
        this.noOfChannels = channelMode;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setPreciseLength(double length) {
        this.trackLength = length;
    }

    public void setSamplingRate(int samplingRate) {
        this.samplingRate = samplingRate;
    }

    public void setBitsPerSample(int bitsPerSample) {
        this.bitsPerSample = bitsPerSample;
    }

    public void setByteRate(int byteRate) {
        this.byteRate = byteRate;
    }

    public void setVariableBitRate(boolean isVbr) {
        this.isVbr = isVbr;
    }

    public void setLossless(boolean isLossless) {
        this.isLossless = isLossless;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("Audio Header content:\n");
        if (this.audioDataLength != null) {
            out.append("\taudioDataLength:" + this.audioDataLength + "\n");
        }
        if (this.audioDataStartPosition != null) {
            out.append("\taudioDataStartPosition:" + this.audioDataStartPosition + "\n");
        }
        if (this.audioDataEndPosition != null) {
            out.append("\taudioDataEndPosition:" + this.audioDataEndPosition + "\n");
        }
        if (this.byteRate != null) {
            out.append("\tbyteRate:" + this.byteRate + "\n");
        }
        if (this.bitRate != null) {
            out.append("\tbitRate:" + this.bitRate + "\n");
        }
        if (this.samplingRate != null) {
            out.append("\tsamplingRate:" + this.samplingRate + "\n");
        }
        if (this.bitsPerSample != null) {
            out.append("\tbitsPerSample:" + this.bitsPerSample + "\n");
        }
        if (this.noOfSamples != null) {
            out.append("\ttotalNoSamples:" + this.noOfSamples + "\n");
        }
        if (this.noOfChannels != null) {
            out.append("\tnumberOfChannels:" + this.noOfChannels + "\n");
        }
        if (this.format != null) {
            out.append("\tformat:" + this.format + "\n");
        }
        if (this.encodingType != null) {
            out.append("\tencodingType:" + this.encodingType + "\n");
        }
        if (this.isVbr != null) {
            out.append("\tisVbr:" + this.isVbr + "\n");
        }
        if (this.isLossless != null) {
            out.append("\tisLossless:" + this.isLossless + "\n");
        }
        if (this.trackLength != null) {
            out.append("\ttrackDuration:" + this.trackLength + "\n");
        }
        return out.toString();
    }

    @Override
    public Long getAudioDataLength() {
        return this.audioDataLength;
    }

    public void setAudioDataLength(long audioDataLength) {
        this.audioDataLength = audioDataLength;
    }

    @Override
    public Integer getByteRate() {
        return this.byteRate;
    }

    @Override
    public Long getNoOfSamples() {
        return this.noOfSamples;
    }

    public void setNoOfSamples(Long noOfSamples) {
        this.noOfSamples = noOfSamples;
    }

    @Override
    public Long getAudioDataStartPosition() {
        return this.audioDataStartPosition;
    }

    public void setAudioDataStartPosition(Long audioDataStartPosition) {
        this.audioDataStartPosition = audioDataStartPosition;
    }

    @Override
    public Long getAudioDataEndPosition() {
        return this.audioDataEndPosition;
    }

    public void setAudioDataEndPosition(Long audioDataEndPosition) {
        this.audioDataEndPosition = audioDataEndPosition;
    }
}

