/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;

public class Mp4EsdsBox
extends AbstractMp4Box {
    public static final int VERSION_FLAG_LENGTH = 1;
    public static final int OTHER_FLAG_LENGTH = 3;
    public static final int DESCRIPTOR_TYPE_LENGTH = 1;
    public static final int ES_ID_LENGTH = 2;
    public static final int STREAM_PRIORITY_LENGTH = 1;
    public static final int CONFIG_TYPE_LENGTH = 1;
    public static final int OBJECT_TYPE_LENGTH = 1;
    public static final int STREAM_TYPE_LENGTH = 1;
    public static final int BUFFER_SIZE_LENGTH = 3;
    public static final int MAX_BITRATE_LENGTH = 4;
    public static final int AVERAGE_BITRATE_LENGTH = 4;
    public static final int DESCRIPTOR_OBJECT_TYPE_LENGTH = 1;
    public static final int CHANNEL_FLAGS_LENGTH = 1;
    private Kind kind;
    private AudioProfile audioProfile;
    private int numberOfChannels;
    private int maxBitrate;
    private int avgBitrate;
    private static final int SECTION_THREE = 3;
    private static final int SECTION_FOUR = 4;
    private static final int SECTION_FIVE = 5;
    private static final int FILLER_START = 128;
    private static final int FILLER_OTHER = 129;
    private static final int FILLER_END = 254;
    private static Map<Integer, Kind> kindMap = new HashMap<Integer, Kind>();
    private static Map<Integer, AudioProfile> audioProfileMap;

    public Mp4EsdsBox(Mp4BoxHeader header, ByteBuffer dataBuffer) {
        this.header = header;
        dataBuffer.order(ByteOrder.BIG_ENDIAN);
        dataBuffer.position(dataBuffer.position() + 1 + 3);
        if (dataBuffer.get() == 3) {
            this.processSectionHeader(dataBuffer);
            dataBuffer.position(dataBuffer.position() + 2 + 1);
        }
        if (dataBuffer.get() == 4) {
            this.processSectionHeader(dataBuffer);
            this.kind = kindMap.get(dataBuffer.get());
            dataBuffer.position(dataBuffer.position() + 1 + 3);
            this.maxBitrate = dataBuffer.getInt();
            this.avgBitrate = dataBuffer.getInt();
        }
        if (dataBuffer.get() == 5) {
            this.processSectionHeader(dataBuffer);
            this.audioProfile = audioProfileMap.get(dataBuffer.get() >> 3);
            byte channelByte = dataBuffer.get();
            this.numberOfChannels = channelByte << 1 >> 4;
        }
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public int getMaxBitrate() {
        return this.maxBitrate;
    }

    public int getAvgBitrate() {
        return this.avgBitrate;
    }

    public int processSectionHeader(ByteBuffer dataBuffer) {
        int datalength;
        byte nextByte = dataBuffer.get();
        if ((nextByte & 0xFF) == 128 || (nextByte & 0xFF) == 129 || (nextByte & 0xFF) == 254) {
            dataBuffer.get();
            dataBuffer.get();
            datalength = Utils.u(dataBuffer.get());
        } else {
            datalength = Utils.u(nextByte);
        }
        return datalength;
    }

    public Kind getKind() {
        return this.kind;
    }

    public AudioProfile getAudioProfile() {
        return this.audioProfile;
    }

    static {
        for (Kind kind : Kind.values()) {
            kindMap.put(kind.getId(), kind);
        }
        audioProfileMap = new HashMap<Integer, AudioProfile>();
        for (Enum enum_ : AudioProfile.values()) {
            audioProfileMap.put(((AudioProfile)enum_).getId(), (AudioProfile)enum_);
        }
    }

    public static enum AudioProfile {
        MAIN(1, "Main"),
        LOW_COMPLEXITY(2, "Low Complexity"),
        SCALEABLE(3, "Scaleable Sample rate"),
        T_F(4, "T/F"),
        T_F_MAIN(5, "T/F Main"),
        T_F_LC(6, "T/F LC"),
        TWIN_VQ(7, "TWIN"),
        CELP(8, "CELP"),
        HVXC(9, "HVXC"),
        HILN(10, "HILN"),
        TTSI(11, "TTSI"),
        MAIN_SYNTHESIS(12, "MAIN_SYNTHESIS"),
        WAVETABLE(13, "WAVETABLE");

        private int id;
        private String description;

        private AudioProfile(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public int getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum Kind {
        V1(1),
        V2(2),
        MPEG4_VIDEO(32),
        MPEG4_AVC_SPS(33),
        MPEG4_AVC_PPS(34),
        MPEG4_AUDIO(64),
        MPEG2_SIMPLE_VIDEO(96),
        MPEG2_MAIN_VIDEO(97),
        MPEG2_SNR_VIDEO(98),
        MPEG2_SPATIAL_VIDEO(99),
        MPEG2_HIGH_VIDEO(100),
        MPEG2_422_VIDEO(101),
        MPEG4_ADTS_MAIN(102),
        MPEG4_ADTS_LOW_COMPLEXITY(103),
        MPEG4_ADTS_SCALEABLE_SAMPLING(104),
        MPEG2_ADTS_MAIN(105),
        MPEG1_VIDEO(106),
        MPEG1_ADTS(107),
        JPEG_VIDEO(108),
        PRIVATE_AUDIO(192),
        PRIVATE_VIDEO(208),
        PCM_LITTLE_ENDIAN_AUDIO(224),
        VORBIS_AUDIO(225),
        DOLBY_V3_AUDIO(226),
        ALAW_AUDIO(227),
        MULAW_AUDIO(228),
        ADPCM_AUDIO(229),
        PCM_BIG_ENDIAN_AUDIO(230),
        YV12_VIDEO(240),
        H264_VIDEO(241),
        H263_VIDEO(242),
        H261_VIDEO(243);

        private int id;

        private Kind(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

