/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.jaudiotagger.audio.wav.WavOptions;
import org.jaudiotagger.audio.wav.WavSaveOptions;
import org.jaudiotagger.audio.wav.WavSaveOrder;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIPL;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;
import org.jaudiotagger.tag.options.PadNumberOption;
import org.jaudiotagger.tag.reference.GenreTypes;
import org.jaudiotagger.tag.reference.ID3V2Version;
import org.jaudiotagger.tag.reference.Languages;
import org.jaudiotagger.tag.vorbiscomment.VorbisAlbumArtistReadOptions;
import org.jaudiotagger.tag.vorbiscomment.VorbisAlbumArtistSaveOptions;

public class TagOptionSingleton {
    private boolean isWriteWavForTwonky = false;
    private WavOptions wavOptions = WavOptions.READ_ID3_ONLY;
    private WavSaveOptions wavSaveOptions = WavSaveOptions.SAVE_BOTH;
    private WavSaveOrder wavSaveOrder = WavSaveOrder.INFO_THEN_ID3;
    private VorbisAlbumArtistSaveOptions vorbisAlbumArtistSaveOptions = VorbisAlbumArtistSaveOptions.WRITE_ALBUMARTIST;
    private VorbisAlbumArtistReadOptions vorbisAlbumArtistReadOptions = VorbisAlbumArtistReadOptions.READ_ALBUMARTIST_THEN_JRIVER;
    private static HashMap<String, TagOptionSingleton> tagOptionTable = new HashMap();
    private static String DEFAULT;
    private static String defaultOptions;
    private HashMap<Class<? extends ID3v24FrameBody>, LinkedList<String>> keywordMap = new HashMap();
    private HashMap<String, Boolean> lyrics3SaveFieldMap = new HashMap();
    private HashMap<String, String> parenthesisMap = new HashMap();
    private HashMap<String, String> replaceWordMap = new HashMap();
    private String language = "eng";
    private boolean filenameTagSave = false;
    private boolean id3v1Save = true;
    private boolean id3v1SaveAlbum = true;
    private boolean id3v1SaveArtist = true;
    private boolean id3v1SaveComment = true;
    private boolean id3v1SaveGenre = true;
    private boolean id3v1SaveTitle = true;
    private boolean id3v1SaveTrack = true;
    private boolean id3v1SaveYear = true;
    private boolean id3v2PaddingCopyTag = true;
    private boolean id3v2PaddingWillShorten = false;
    private boolean id3v2Save = true;
    private boolean id3v2ITunes12_6WorkGroupingMode = false;
    private boolean lyrics3KeepEmptyFieldIfRead = false;
    private boolean lyrics3Save = true;
    private boolean lyrics3SaveEmptyField = false;
    private boolean originalSavedAfterAdjustingID3v2Padding = true;
    private byte timeStampFormat = (byte)2;
    private int numberMP3SyncFrame = 3;
    private boolean unsyncTags = false;
    private boolean removeTrailingTerminatorOnWrite = true;
    private byte id3v23DefaultTextEncoding = 0;
    private byte id3v24DefaultTextEncoding = 0;
    private byte id3v24UnicodeTextEncoding = 1;
    private boolean resetTextEncodingForExistingFrames = false;
    private boolean truncateTextWithoutErrors = false;
    private boolean padNumbers = false;
    private PadNumberOption padNumberTotalLength = PadNumberOption.PAD_ONE_ZERO;
    private boolean isAndroid = false;
    private boolean isAPICDescriptionITunesCompatible = false;
    private boolean isEncodeUTF16BomAsLittleEndian = true;
    private int playerCompatability = -1;
    private long writeChunkSize = 0x400000L;
    private boolean isWriteMp4GenresAsText = false;
    private boolean isWriteMp3GenresAsText = false;
    private ID3V2Version id3v2Version = ID3V2Version.ID3_V23;
    private boolean checkIsWritable = false;
    private boolean preserveFileIdentity = true;

    public void setWavOptions(WavOptions wavOptions) {
        this.wavOptions = wavOptions;
    }

    public WavOptions getWavOptions() {
        return this.wavOptions;
    }

    public void setWavSaveOptions(WavSaveOptions wavSaveOptions) {
        this.wavSaveOptions = wavSaveOptions;
    }

    public WavSaveOptions getWavSaveOptions() {
        return this.wavSaveOptions;
    }

    public void setWavSaveOrder(WavSaveOrder wavSaveOrder) {
        this.wavSaveOrder = wavSaveOrder;
    }

    public WavSaveOrder getWavSaveOrder() {
        return this.wavSaveOrder;
    }

    public void setVorbisAlbumArtistSaveOptions(VorbisAlbumArtistSaveOptions vorbisAlbumArtistSaveOptions) {
        this.vorbisAlbumArtistSaveOptions = vorbisAlbumArtistSaveOptions;
    }

    public VorbisAlbumArtistSaveOptions getVorbisAlbumArtistSaveOptions() {
        return this.vorbisAlbumArtistSaveOptions;
    }

    public void setVorbisAlbumArtistReadOptions(VorbisAlbumArtistReadOptions vorbisAlbumArtistReadOptions) {
        this.vorbisAlbumArtistReadOptions = vorbisAlbumArtistReadOptions;
    }

    public VorbisAlbumArtistReadOptions getVorbisAlbumArtisReadOptions() {
        return this.vorbisAlbumArtistReadOptions;
    }

    private TagOptionSingleton() {
        this.setToDefault();
    }

    public static TagOptionSingleton getInstance() {
        return TagOptionSingleton.getInstance(defaultOptions);
    }

    public static TagOptionSingleton getInstance(String instanceKey) {
        TagOptionSingleton tagOptions = tagOptionTable.get(instanceKey);
        if (tagOptions == null) {
            tagOptions = new TagOptionSingleton();
            tagOptionTable.put(instanceKey, tagOptions);
        }
        return tagOptions;
    }

    public void setFilenameTagSave(boolean filenameTagSave) {
        this.filenameTagSave = filenameTagSave;
    }

    public boolean isFilenameTagSave() {
        return this.filenameTagSave;
    }

    public void setID3V2Version(ID3V2Version id3v2Version) {
        this.id3v2Version = id3v2Version;
    }

    public ID3V2Version getID3V2Version() {
        return this.id3v2Version;
    }

    public void setInstanceKey(String instanceKey) {
        defaultOptions = instanceKey;
    }

    public static String getInstanceKey() {
        return defaultOptions;
    }

    public void setId3v1Save(boolean id3v1Save) {
        this.id3v1Save = id3v1Save;
    }

    public boolean isId3v1Save() {
        return this.id3v1Save;
    }

    public void setId3v1SaveAlbum(boolean id3v1SaveAlbum) {
        this.id3v1SaveAlbum = id3v1SaveAlbum;
    }

    public boolean isId3v1SaveAlbum() {
        return this.id3v1SaveAlbum;
    }

    public void setId3v1SaveArtist(boolean id3v1SaveArtist) {
        this.id3v1SaveArtist = id3v1SaveArtist;
    }

    public boolean isId3v1SaveArtist() {
        return this.id3v1SaveArtist;
    }

    public void setId3v1SaveComment(boolean id3v1SaveComment) {
        this.id3v1SaveComment = id3v1SaveComment;
    }

    public boolean isId3v1SaveComment() {
        return this.id3v1SaveComment;
    }

    public void setId3v1SaveGenre(boolean id3v1SaveGenre) {
        this.id3v1SaveGenre = id3v1SaveGenre;
    }

    public boolean isId3v1SaveGenre() {
        return this.id3v1SaveGenre;
    }

    public void setId3v1SaveTitle(boolean id3v1SaveTitle) {
        this.id3v1SaveTitle = id3v1SaveTitle;
    }

    public boolean isId3v1SaveTitle() {
        return this.id3v1SaveTitle;
    }

    public void setId3v1SaveTrack(boolean id3v1SaveTrack) {
        this.id3v1SaveTrack = id3v1SaveTrack;
    }

    public boolean isId3v1SaveTrack() {
        return this.id3v1SaveTrack;
    }

    public void setId3v1SaveYear(boolean id3v1SaveYear) {
        this.id3v1SaveYear = id3v1SaveYear;
    }

    public boolean isId3v1SaveYear() {
        return this.id3v1SaveYear;
    }

    public void setId3v2PaddingCopyTag(boolean id3v2PaddingCopyTag) {
        this.id3v2PaddingCopyTag = id3v2PaddingCopyTag;
    }

    public boolean isId3v2PaddingCopyTag() {
        return this.id3v2PaddingCopyTag;
    }

    public void setId3v2PaddingWillShorten(boolean id3v2PaddingWillShorten) {
        this.id3v2PaddingWillShorten = id3v2PaddingWillShorten;
    }

    public boolean isId3v2PaddingWillShorten() {
        return this.id3v2PaddingWillShorten;
    }

    public void setId3v2Save(boolean id3v2Save) {
        this.id3v2Save = id3v2Save;
    }

    public boolean isId3v2Save() {
        return this.id3v2Save;
    }

    public boolean isId3v2ITunes12_6WorkGroupingMode() {
        return this.id3v2ITunes12_6WorkGroupingMode;
    }

    public void setId3v2ITunes12_6WorkGroupingMode(boolean id3v2ITunes12_6WorkGroupingMode) {
        boolean oldMode = this.id3v2ITunes12_6WorkGroupingMode;
        if (oldMode != id3v2ITunes12_6WorkGroupingMode) {
            ID3v22Frames.getInstanceOf().setITunes12_6WorkGroupingMode(id3v2ITunes12_6WorkGroupingMode);
            ID3v23Frames.getInstanceOf().setITunes12_6WorkGroupingMode(id3v2ITunes12_6WorkGroupingMode);
            ID3v24Frames.getInstanceOf().setITunes12_6WorkGroupingMode(id3v2ITunes12_6WorkGroupingMode);
            this.id3v2ITunes12_6WorkGroupingMode = id3v2ITunes12_6WorkGroupingMode;
        }
    }

    public Iterator<Class<? extends ID3v24FrameBody>> getKeywordIterator() {
        return this.keywordMap.keySet().iterator();
    }

    public Iterator<String> getKeywordListIterator(Class<? extends ID3v24FrameBody> id3v2_4FrameBody) {
        return this.keywordMap.get(id3v2_4FrameBody).iterator();
    }

    public void setLanguage(String lang) {
        if (Languages.getInstanceOf().getIdToValueMap().containsKey(lang)) {
            this.language = lang;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLyrics3KeepEmptyFieldIfRead(boolean lyrics3KeepEmptyFieldIfRead) {
        this.lyrics3KeepEmptyFieldIfRead = lyrics3KeepEmptyFieldIfRead;
    }

    public boolean isLyrics3KeepEmptyFieldIfRead() {
        return this.lyrics3KeepEmptyFieldIfRead;
    }

    public void setLyrics3Save(boolean lyrics3Save) {
        this.lyrics3Save = lyrics3Save;
    }

    public boolean isLyrics3Save() {
        return this.lyrics3Save;
    }

    public void setLyrics3SaveEmptyField(boolean lyrics3SaveEmptyField) {
        this.lyrics3SaveEmptyField = lyrics3SaveEmptyField;
    }

    public boolean isLyrics3SaveEmptyField() {
        return this.lyrics3SaveEmptyField;
    }

    public void setLyrics3SaveField(String id, boolean save) {
        this.lyrics3SaveFieldMap.put(id, save);
    }

    public boolean getLyrics3SaveField(String id) {
        return this.lyrics3SaveFieldMap.get(id);
    }

    public HashMap<String, Boolean> getLyrics3SaveFieldMap() {
        return this.lyrics3SaveFieldMap;
    }

    public String getNewReplaceWord(String oldWord) {
        return this.replaceWordMap.get(oldWord);
    }

    public void setNumberMP3SyncFrame(int numberMP3SyncFrame) {
        this.numberMP3SyncFrame = numberMP3SyncFrame;
    }

    public int getNumberMP3SyncFrame() {
        return this.numberMP3SyncFrame;
    }

    public Iterator<String> getOldReplaceWordIterator() {
        return this.replaceWordMap.keySet().iterator();
    }

    public boolean isOpenParenthesis(String open) {
        return this.parenthesisMap.containsKey(open);
    }

    public Iterator<String> getOpenParenthesisIterator() {
        return this.parenthesisMap.keySet().iterator();
    }

    public void setOriginalSavedAfterAdjustingID3v2Padding(boolean originalSavedAfterAdjustingID3v2Padding) {
        this.originalSavedAfterAdjustingID3v2Padding = originalSavedAfterAdjustingID3v2Padding;
    }

    public boolean isOriginalSavedAfterAdjustingID3v2Padding() {
        return this.originalSavedAfterAdjustingID3v2Padding;
    }

    public void setTimeStampFormat(byte tsf) {
        if (tsf == 1 || tsf == 2) {
            this.timeStampFormat = tsf;
        }
    }

    public byte getTimeStampFormat() {
        return this.timeStampFormat;
    }

    public void setToDefault() {
        Iterator<Object> iterator;
        this.isWriteWavForTwonky = false;
        this.wavOptions = WavOptions.READ_ID3_UNLESS_ONLY_INFO;
        this.wavSaveOptions = WavSaveOptions.SAVE_BOTH;
        this.keywordMap = new HashMap();
        this.filenameTagSave = false;
        this.id3v1Save = true;
        this.id3v1SaveAlbum = true;
        this.id3v1SaveArtist = true;
        this.id3v1SaveComment = true;
        this.id3v1SaveGenre = true;
        this.id3v1SaveTitle = true;
        this.id3v1SaveTrack = true;
        this.id3v1SaveYear = true;
        this.id3v2PaddingCopyTag = true;
        this.id3v2PaddingWillShorten = false;
        this.id3v2Save = true;
        this.language = "eng";
        this.lyrics3KeepEmptyFieldIfRead = false;
        this.lyrics3Save = true;
        this.lyrics3SaveEmptyField = false;
        this.lyrics3SaveFieldMap = new HashMap();
        this.numberMP3SyncFrame = 3;
        this.parenthesisMap = new HashMap();
        this.replaceWordMap = new HashMap();
        this.timeStampFormat = (byte)2;
        this.unsyncTags = false;
        this.removeTrailingTerminatorOnWrite = true;
        this.id3v23DefaultTextEncoding = 0;
        this.id3v24DefaultTextEncoding = 0;
        this.id3v24UnicodeTextEncoding = 1;
        this.resetTextEncodingForExistingFrames = false;
        this.truncateTextWithoutErrors = false;
        this.padNumbers = false;
        this.isAPICDescriptionITunesCompatible = false;
        this.isAndroid = false;
        this.isEncodeUTF16BomAsLittleEndian = true;
        this.writeChunkSize = 5000000L;
        this.isWriteMp4GenresAsText = false;
        this.padNumberTotalLength = PadNumberOption.PAD_ONE_ZERO;
        this.id3v2Version = ID3V2Version.ID3_V23;
        this.checkIsWritable = false;
        this.preserveFileIdentity = true;
        for (String fieldId : Lyrics3v2Fields.getInstanceOf().getIdToValueMap().keySet()) {
            this.lyrics3SaveFieldMap.put(fieldId, true);
        }
        try {
            this.addKeyword(FrameBodyCOMM.class, "ultimix");
            this.addKeyword(FrameBodyCOMM.class, "dance");
            this.addKeyword(FrameBodyCOMM.class, "mix");
            this.addKeyword(FrameBodyCOMM.class, "remix");
            this.addKeyword(FrameBodyCOMM.class, "rmx");
            this.addKeyword(FrameBodyCOMM.class, "live");
            this.addKeyword(FrameBodyCOMM.class, "cover");
            this.addKeyword(FrameBodyCOMM.class, "soundtrack");
            this.addKeyword(FrameBodyCOMM.class, "version");
            this.addKeyword(FrameBodyCOMM.class, "acoustic");
            this.addKeyword(FrameBodyCOMM.class, "original");
            this.addKeyword(FrameBodyCOMM.class, "cd");
            this.addKeyword(FrameBodyCOMM.class, "extended");
            this.addKeyword(FrameBodyCOMM.class, "vocal");
            this.addKeyword(FrameBodyCOMM.class, "unplugged");
            this.addKeyword(FrameBodyCOMM.class, "acapella");
            this.addKeyword(FrameBodyCOMM.class, "edit");
            this.addKeyword(FrameBodyCOMM.class, "radio");
            this.addKeyword(FrameBodyCOMM.class, "original");
            this.addKeyword(FrameBodyCOMM.class, "album");
            this.addKeyword(FrameBodyCOMM.class, "studio");
            this.addKeyword(FrameBodyCOMM.class, "instrumental");
            this.addKeyword(FrameBodyCOMM.class, "unedited");
            this.addKeyword(FrameBodyCOMM.class, "karoke");
            this.addKeyword(FrameBodyCOMM.class, "quality");
            this.addKeyword(FrameBodyCOMM.class, "uncensored");
            this.addKeyword(FrameBodyCOMM.class, "clean");
            this.addKeyword(FrameBodyCOMM.class, "dirty");
            this.addKeyword(FrameBodyTIPL.class, "f.");
            this.addKeyword(FrameBodyTIPL.class, "feat");
            this.addKeyword(FrameBodyTIPL.class, "feat.");
            this.addKeyword(FrameBodyTIPL.class, "featuring");
            this.addKeyword(FrameBodyTIPL.class, "ftng");
            this.addKeyword(FrameBodyTIPL.class, "ftng.");
            this.addKeyword(FrameBodyTIPL.class, "ft.");
            this.addKeyword(FrameBodyTIPL.class, "ft");
            iterator = GenreTypes.getInstanceOf().getValueToIdMap().keySet().iterator();
            while (iterator.hasNext()) {
                this.addKeyword(FrameBodyCOMM.class, (String)iterator.next());
            }
        }
        catch (TagException ex) {
            throw new RuntimeException(ex);
        }
        this.addReplaceWord("v.", "vs.");
        this.addReplaceWord("vs.", "vs.");
        this.addReplaceWord("versus", "vs.");
        this.addReplaceWord("f.", "feat.");
        this.addReplaceWord("feat", "feat.");
        this.addReplaceWord("featuring", "feat.");
        this.addReplaceWord("ftng.", "feat.");
        this.addReplaceWord("ftng", "feat.");
        this.addReplaceWord("ft.", "feat.");
        this.addReplaceWord("ft", "feat.");
        iterator = this.getKeywordListIterator(FrameBodyTIPL.class);
        this.addParenthesis("(", ")");
        this.addParenthesis("[", "]");
        this.addParenthesis("{", "}");
        this.addParenthesis("<", ">");
    }

    public void addKeyword(Class<? extends ID3v24FrameBody> id3v2FrameBodyClass, String keyword) throws TagException {
        if (!AbstractID3v2FrameBody.class.isAssignableFrom(id3v2FrameBodyClass)) {
            throw new TagException("Invalid class type. Must be AbstractId3v2FrameBody " + id3v2FrameBodyClass);
        }
        if (keyword != null && keyword.length() > 0) {
            LinkedList<Object> keywordList;
            if (!this.keywordMap.containsKey(id3v2FrameBodyClass)) {
                keywordList = new LinkedList();
                this.keywordMap.put(id3v2FrameBodyClass, keywordList);
            } else {
                keywordList = this.keywordMap.get(id3v2FrameBodyClass);
            }
            keywordList.add(keyword);
        }
    }

    public void addParenthesis(String open, String close) {
        this.parenthesisMap.put(open, close);
    }

    public void addReplaceWord(String oldWord, String newWord) {
        this.replaceWordMap.put(oldWord, newWord);
    }

    public boolean isUnsyncTags() {
        return this.unsyncTags;
    }

    public void setUnsyncTags(boolean unsyncTags) {
        this.unsyncTags = unsyncTags;
    }

    public boolean isRemoveTrailingTerminatorOnWrite() {
        return this.removeTrailingTerminatorOnWrite;
    }

    public void setRemoveTrailingTerminatorOnWrite(boolean removeTrailingTerminatorOnWrite) {
        this.removeTrailingTerminatorOnWrite = removeTrailingTerminatorOnWrite;
    }

    public byte getId3v23DefaultTextEncoding() {
        return this.id3v23DefaultTextEncoding;
    }

    public void setId3v23DefaultTextEncoding(byte id3v23DefaultTextEncoding) {
        if (id3v23DefaultTextEncoding == 0 || id3v23DefaultTextEncoding == 1) {
            this.id3v23DefaultTextEncoding = id3v23DefaultTextEncoding;
        }
    }

    public byte getId3v24DefaultTextEncoding() {
        return this.id3v24DefaultTextEncoding;
    }

    public void setId3v24DefaultTextEncoding(byte id3v24DefaultTextEncoding) {
        if (id3v24DefaultTextEncoding == 0 || id3v24DefaultTextEncoding == 1 || id3v24DefaultTextEncoding == 2 || id3v24DefaultTextEncoding == 3) {
            this.id3v24DefaultTextEncoding = id3v24DefaultTextEncoding;
        }
    }

    public byte getId3v24UnicodeTextEncoding() {
        return this.id3v24UnicodeTextEncoding;
    }

    public void setId3v24UnicodeTextEncoding(byte id3v24UnicodeTextEncoding) {
        if (id3v24UnicodeTextEncoding == 1 || id3v24UnicodeTextEncoding == 2 || id3v24UnicodeTextEncoding == 3) {
            this.id3v24UnicodeTextEncoding = id3v24UnicodeTextEncoding;
        }
    }

    public boolean isResetTextEncodingForExistingFrames() {
        return this.resetTextEncodingForExistingFrames;
    }

    public void setResetTextEncodingForExistingFrames(boolean resetTextEncodingForExistingFrames) {
        this.resetTextEncodingForExistingFrames = resetTextEncodingForExistingFrames;
    }

    public boolean isTruncateTextWithoutErrors() {
        return this.truncateTextWithoutErrors;
    }

    public void setTruncateTextWithoutErrors(boolean truncateTextWithoutErrors) {
        this.truncateTextWithoutErrors = truncateTextWithoutErrors;
    }

    public boolean isPadNumbers() {
        return this.padNumbers;
    }

    public void setPadNumbers(boolean padNumbers) {
        this.padNumbers = padNumbers;
    }

    public boolean isAndroid() {
        return this.isAndroid;
    }

    public void setAndroid(boolean android) {
        this.isAndroid = android;
    }

    public int getPlayerCompatability() {
        return this.playerCompatability;
    }

    public void setPlayerCompatability(int playerCompatability) {
        this.playerCompatability = playerCompatability;
    }

    public boolean isEncodeUTF16BomAsLittleEndian() {
        return this.isEncodeUTF16BomAsLittleEndian;
    }

    public void setEncodeUTF16BomAsLittleEndian(boolean encodeUTF16BomAsLittleEndian) {
        this.isEncodeUTF16BomAsLittleEndian = encodeUTF16BomAsLittleEndian;
    }

    public long getWriteChunkSize() {
        return this.writeChunkSize;
    }

    public void setWriteChunkSize(long writeChunkSize) {
        this.writeChunkSize = writeChunkSize;
    }

    public boolean isWriteMp4GenresAsText() {
        return this.isWriteMp4GenresAsText;
    }

    public void setWriteMp4GenresAsText(boolean writeMp4GenresAsText) {
        this.isWriteMp4GenresAsText = writeMp4GenresAsText;
    }

    public boolean isWriteMp3GenresAsText() {
        return this.isWriteMp3GenresAsText;
    }

    public void setWriteMp3GenresAsText(boolean writeMp3GenresAsText) {
        this.isWriteMp3GenresAsText = writeMp3GenresAsText;
    }

    public PadNumberOption getPadNumberTotalLength() {
        return this.padNumberTotalLength;
    }

    public void setPadNumberTotalLength(PadNumberOption padNumberTotalLength) {
        this.padNumberTotalLength = padNumberTotalLength;
    }

    public boolean isAPICDescriptionITunesCompatible() {
        return this.isAPICDescriptionITunesCompatible;
    }

    public void setAPICDescriptionITunesCompatible(boolean APICDescriptionITunesCompatible) {
        this.isAPICDescriptionITunesCompatible = APICDescriptionITunesCompatible;
    }

    public boolean isCheckIsWritable() {
        return this.checkIsWritable;
    }

    public void setCheckIsWritable(boolean checkIsWritable) {
        this.checkIsWritable = checkIsWritable;
    }

    public boolean isPreserveFileIdentity() {
        return this.preserveFileIdentity;
    }

    public void setPreserveFileIdentity(boolean preserveFileIdentity) {
        this.preserveFileIdentity = preserveFileIdentity;
    }

    public boolean isWriteWavForTwonky() {
        return this.isWriteWavForTwonky;
    }

    public void setWriteWavForTwonky(boolean isWriteWavForTwonky) {
        this.isWriteWavForTwonky = isWriteWavForTwonky;
    }

    static {
        defaultOptions = DEFAULT = "default";
    }
}

