/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.images;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.images.ImageHandler;

public class StandardImageHandler
implements ImageHandler {
    private static StandardImageHandler instance;

    public static StandardImageHandler getInstanceOf() {
        if (instance == null) {
            instance = new StandardImageHandler();
        }
        return instance;
    }

    private StandardImageHandler() {
    }

    @Override
    public void reduceQuality(Artwork artwork, int maxSize) throws IOException {
        while (artwork.getBinaryData().length > maxSize) {
            Image srcImage = (Image)artwork.getImage();
            int w = srcImage.getWidth(null);
            int newSize = w / 2;
            this.makeSmaller(artwork, newSize);
        }
    }

    @Override
    public void makeSmaller(Artwork artwork, int size) throws IOException {
        Image srcImage = (Image)artwork.getImage();
        int w = srcImage.getWidth(null);
        int h = srcImage.getHeight(null);
        float scaleW = (float)size / (float)w;
        float scaleH = (float)size / (float)h;
        BufferedImage bi = new BufferedImage(size, size, 1);
        AffineTransform tx = new AffineTransform();
        tx.scale(scaleW, scaleH);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(srcImage, tx, null);
        g2d.dispose();
        if (artwork.getMimeType() != null && this.isMimeTypeWritable(artwork.getMimeType())) {
            artwork.setBinaryData(this.writeImage(bi, artwork.getMimeType()));
        } else {
            artwork.setBinaryData(this.writeImageAsPng(bi));
        }
    }

    @Override
    public boolean isMimeTypeWritable(String mimeType) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeType);
        return writers.hasNext();
    }

    @Override
    public byte[] writeImage(BufferedImage bi, String mimeType) throws IOException {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mimeType);
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writer.setOutput(ImageIO.createImageOutputStream(baos));
            writer.write(bi);
            return baos.toByteArray();
        }
        throw new IOException("Cannot write to this mimetype");
    }

    @Override
    public byte[] writeImageAsPng(BufferedImage bi) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "image/png", baos);
        return baos.toByteArray();
    }

    @Override
    public void showReadFormats() {
        String[] formats;
        for (String f : formats = ImageIO.getReaderMIMETypes()) {
            System.out.println("r" + f);
        }
    }

    @Override
    public void showWriteFormats() {
        String[] formats;
        for (String f : formats = ImageIO.getWriterMIMETypes()) {
            System.out.println(f);
        }
    }
}

