/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyIND;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.Lyrics3v1;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Field;

public class Lyrics3v2
extends AbstractLyrics3 {
    private HashMap<String, Lyrics3v2Field> fieldMap = new HashMap();

    public Lyrics3v2() {
    }

    public Lyrics3v2(Lyrics3v2 copyObject) {
        super(copyObject);
        Iterator<String> iterator = copyObject.fieldMap.keySet().iterator();
        while (iterator.hasNext()) {
            String oldIdentifier;
            String newIdentifier = oldIdentifier = iterator.next();
            Lyrics3v2Field newObject = new Lyrics3v2Field(copyObject.fieldMap.get(newIdentifier));
            this.fieldMap.put(newIdentifier, newObject);
        }
    }

    public Lyrics3v2(AbstractTag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof Lyrics3v2) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            if (mp3tag instanceof Lyrics3v1) {
                Lyrics3v1 lyricOld = (Lyrics3v1)mp3tag;
                Lyrics3v2Field newField = new Lyrics3v2Field(new FieldFrameBodyLYR(lyricOld.getLyric()));
                this.fieldMap.put(newField.getIdentifier(), newField);
            } else {
                Iterator<List<TagField>> iterator = new ID3v24Tag(mp3tag).iterator();
                while (iterator.hasNext()) {
                    try {
                        List<TagField> fields = iterator.next();
                        for (TagField element : fields) {
                            Lyrics3v2Field newField;
                            AbstractID3v2Frame frame;
                            if (!(element instanceof AbstractID3v2Frame) || !Lyrics3v2Field.isLyrics3v2Field(frame = (AbstractID3v2Frame)element) || (newField = new Lyrics3v2Field(frame)) == null) continue;
                            this.fieldMap.put(newField.getIdentifier(), newField);
                        }
                    }
                    catch (TagException tagException) {
                    }
                }
            }
        }
    }

    public Lyrics3v2(ByteBuffer byteBuffer) throws TagNotFoundException, IOException {
        try {
            this.read(byteBuffer);
        }
        catch (TagException e) {
            e.printStackTrace();
        }
    }

    public void setField(Lyrics3v2Field field) {
        this.fieldMap.put(field.getIdentifier(), field);
    }

    public Lyrics3v2Field getField(String identifier) {
        return this.fieldMap.get(identifier);
    }

    public int getFieldCount() {
        return this.fieldMap.size();
    }

    @Override
    public String getIdentifier() {
        return "Lyrics3v2.00";
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Lyrics3v2Field field : this.fieldMap.values()) {
            size += field.getSize();
        }
        return 11 + size;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Lyrics3v2)) {
            return false;
        }
        Lyrics3v2 object = (Lyrics3v2)obj;
        return this.fieldMap.equals(object.fieldMap) && super.equals(obj);
    }

    public boolean hasField(String identifier) {
        return this.fieldMap.containsKey(identifier);
    }

    public Iterator<Lyrics3v2Field> iterator() {
        return this.fieldMap.values().iterator();
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        return false;
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException("Lyrics3v2.00 Tag Not Found");
        }
        int lyricSize = this.seekSize(byteBuffer);
        this.seek(byteBuffer);
        byteBuffer.position();
        this.fieldMap = new HashMap();
        while (byteBuffer.position() < lyricSize - 11) {
            try {
                Lyrics3v2Field lyric = new Lyrics3v2Field(byteBuffer);
                this.setField(lyric);
            }
            catch (InvalidTagException invalidTagException) {}
        }
    }

    public void removeField(String identifier) {
        this.fieldMap.remove(identifier);
    }

    public boolean seek(RandomAccessFile file) throws IOException {
        long filePointer;
        byte[] buffer = new byte[11];
        file.seek(file.length() - 128L - 9L);
        file.read(buffer, 0, 9);
        String lyricEnd = new String(buffer, 0, 9);
        if (lyricEnd.equals("LYRICS200")) {
            filePointer = file.getFilePointer();
        } else {
            file.seek(file.length() - 9L);
            file.read(buffer, 0, 9);
            lyricEnd = new String(buffer, 0, 9);
            if (lyricEnd.equals("LYRICS200")) {
                filePointer = file.getFilePointer();
            } else {
                return false;
            }
        }
        file.seek(filePointer -= 15L);
        file.read(buffer, 0, 6);
        long lyricSize = Integer.parseInt(new String(buffer, 0, 6));
        file.seek(filePointer - lyricSize);
        file.read(buffer, 0, 11);
        String lyricStart = new String(buffer, 0, 11);
        return lyricStart.equals("LYRICSBEGIN");
    }

    public String toString() {
        Iterator<Lyrics3v2Field> iterator = this.fieldMap.values().iterator();
        String str = this.getIdentifier() + " " + this.getSize() + "\n";
        while (iterator.hasNext()) {
            Lyrics3v2Field field = iterator.next();
            str = str + field.toString() + "\n";
        }
        return str;
    }

    public void updateField(String identifier) {
        if (identifier.equals("IND")) {
            Lyrics3v2Field lyrField;
            boolean lyricsPresent = this.fieldMap.containsKey("LYR");
            boolean timeStampPresent = false;
            if (lyricsPresent) {
                lyrField = this.fieldMap.get("LYR");
                FieldFrameBodyLYR lyrBody = (FieldFrameBodyLYR)lyrField.getBody();
                timeStampPresent = lyrBody.hasTimeStamp();
            }
            lyrField = new Lyrics3v2Field(new FieldFrameBodyIND(lyricsPresent, timeStampPresent));
            this.setField(lyrField);
        }
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
        int i;
        int offset = 0;
        byte[] buffer = new byte[15];
        new ID3v1Tag();
        this.delete(file);
        file.seek(file.length());
        long filePointer = file.getFilePointer();
        String str = "LYRICSBEGIN";
        for (i = 0; i < str.length(); ++i) {
            buffer[i] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, str.length());
        this.updateField("IND");
        Lyrics3v2Field field2 = this.fieldMap.get("IND");
        field2.write(file);
        for (Lyrics3v2Field field2 : this.fieldMap.values()) {
            String id = field2.getIdentifier();
            boolean save = TagOptionSingleton.getInstance().getLyrics3SaveField(id);
            if (id.equals("IND") || !save) continue;
            field2.write(file);
        }
        long size = file.getFilePointer() - filePointer;
        if ((long)this.getSize() != size) {
            // empty if block
        }
        str = Long.toString(size);
        for (i = 0; i < 6 - str.length(); ++i) {
            buffer[i] = 48;
        }
        offset += 6 - str.length();
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        str = "LYRICS200";
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        file.write(buffer, 0, offset += str.length());
    }

    private int seekSize(ByteBuffer byteBuffer) {
        return -1;
    }
}

