/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import org.codehaus.plexus.util.FileUtils;

public class CsvSummaryFileTarget
implements ExecutionTarget {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CSV_COLUMN_SEPARATOR = ",";
    public static final String CSV_COMMENT_MARKER = "#";
    protected String encoding;
    protected Map<File, Map<String, String>> filesHashcodes;
    protected SortedSet<String> algorithms;
    protected File summaryFile;

    public CsvSummaryFileTarget(File summaryFile, String encoding) {
        this.summaryFile = summaryFile;
        this.encoding = encoding;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<File, Map<String, String>>();
        this.algorithms = new TreeSet<String>();
    }

    @Override
    public void write(String digest, File file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
        this.algorithms.add(algorithm);
    }

    @Override
    public void close() throws ExecutionTargetCloseException {
        StringBuilder sb = new StringBuilder();
        sb.append(CSV_COMMENT_MARKER).append("File");
        for (String algorithm : this.algorithms) {
            sb.append(CSV_COLUMN_SEPARATOR).append(algorithm);
        }
        for (File file : this.filesHashcodes.keySet()) {
            sb.append(LINE_SEPARATOR).append(file.getName());
            Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
            for (String algorithm : this.algorithms) {
                sb.append(CSV_COLUMN_SEPARATOR);
                if (!fileHashcodes.containsKey(algorithm)) continue;
                sb.append(fileHashcodes.get(algorithm));
            }
        }
        FileUtils.mkdir((String)this.summaryFile.getParent());
        try {
            FileUtils.fileWrite((String)this.summaryFile.getPath(), (String)this.encoding, (String)sb.toString());
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
    }
}

