/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.execution.target;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTarget;
import net.nicoulaj.maven.plugins.checksum.execution.target.ExecutionTargetCloseException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public class XmlSummaryFileTarget
implements ExecutionTarget {
    public static final int XML_INDENTATION_SIZE = 2;
    protected String encoding;
    protected Map<File, Map<String, String>> filesHashcodes;
    protected File summaryFile;

    public XmlSummaryFileTarget(File summaryFile, String encoding) {
        this.summaryFile = summaryFile;
        this.encoding = encoding;
    }

    @Override
    public void init() {
        this.filesHashcodes = new HashMap<File, Map<String, String>>();
    }

    @Override
    public void write(String digest, File file, String algorithm) {
        if (!this.filesHashcodes.containsKey(file)) {
            this.filesHashcodes.put(file, new HashMap());
        }
        Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
        fileHashcodes.put(algorithm, digest);
    }

    @Override
    public void close() throws ExecutionTargetCloseException {
        OutputStreamWriter outputStream;
        FileUtils.mkdir((String)this.summaryFile.getParent());
        try {
            outputStream = new OutputStreamWriter((OutputStream)new FileOutputStream(this.summaryFile), this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter((Writer)outputStream, StringUtils.repeat((String)" ", (int)2));
        xmlWriter.startElement("files");
        for (File file : this.filesHashcodes.keySet()) {
            xmlWriter.startElement("file");
            xmlWriter.addAttribute("name", file.getName());
            Map<String, String> fileHashcodes = this.filesHashcodes.get(file);
            for (String algorithm : fileHashcodes.keySet()) {
                xmlWriter.startElement("hashcode");
                xmlWriter.addAttribute("algorithm", algorithm);
                xmlWriter.writeText(fileHashcodes.get(algorithm));
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            ((Writer)outputStream).close();
        }
        catch (IOException e) {
            throw new ExecutionTargetCloseException(e.getMessage());
        }
    }
}

