/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import java.util.Objects;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class NotEqualIgnoreCase<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 2L;
    protected String expectedValue;
    private Converter converter;

    public NotEqualIgnoreCase(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException();
        }
        this.expectedValue = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        if (this.path(root).getJavaType().equals(String.class)) {
            return cb.notEqual(cb.upper(this.path(root)), (Object)this.expectedValue.toUpperCase());
        }
        Class typeOnPath = this.path(root).getJavaType();
        return cb.notEqual(this.path(root), this.converter.convert(this.expectedValue, typeOnPath, true));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotEqualIgnoreCase notEqual = (NotEqualIgnoreCase)o;
        return Objects.equals(this.expectedValue, notEqual.expectedValue) && Objects.equals(this.converter, notEqual.converter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.expectedValue, this.converter);
    }

    public String toString() {
        return "NotEqualIgnoreCase[expectedValue='" + this.expectedValue + '\'' + ", converter=" + this.converter + ", path='" + this.path + '\'' + ']';
    }
}

