/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.swagger;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kaczmarzyk.spring.data.jpa.web.annotation.And;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Conjunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Disjunction;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Or;
import net.kaczmarzyk.spring.data.jpa.web.annotation.Spec;

public class SpecExtractorUtil {
    private static final Map<Class<?>, Function<Annotation, List<Spec>>> NESTED_SPEC_ANNOTATION_EXTRACTORS = new HashMap();

    private SpecExtractorUtil() {
    }

    public static List<Spec> extractNestedSpecificationsFromAnnotations(List<Annotation> annotations) {
        return annotations.stream().filter(annotation -> NESTED_SPEC_ANNOTATION_EXTRACTORS.containsKey(annotation.annotationType())).map(annotation -> NESTED_SPEC_ANNOTATION_EXTRACTORS.get(annotation.annotationType()).apply((Annotation)annotation)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<Spec> extractSpecsFromOr(Or or) {
        return Arrays.asList(or.value());
    }

    private static List<Spec> extractSpecsFromAnd(And and) {
        return Arrays.asList(and.value());
    }

    private static List<Spec> extractSpecsFromConjunction(Conjunction conjunction) {
        ArrayList<Spec> conjunctionSpecs = new ArrayList<Spec>(Arrays.asList(conjunction.and()));
        Arrays.stream(conjunction.value()).map(Or::value).flatMap(Arrays::stream).forEach(conjunctionSpecs::add);
        return conjunctionSpecs;
    }

    private static List<Spec> extractSpecsFromDisjunction(Disjunction conjunction) {
        ArrayList<Spec> disjunctionSpecs = new ArrayList<Spec>(Arrays.asList(conjunction.or()));
        Arrays.stream(conjunction.value()).map(And::value).flatMap(Arrays::stream).forEach(disjunctionSpecs::add);
        return disjunctionSpecs;
    }

    static {
        NESTED_SPEC_ANNOTATION_EXTRACTORS.put(Spec.class, annotation -> Collections.singletonList((Spec)annotation));
        NESTED_SPEC_ANNOTATION_EXTRACTORS.put(And.class, annotation -> SpecExtractorUtil.extractSpecsFromAnd((And)annotation));
        NESTED_SPEC_ANNOTATION_EXTRACTORS.put(Or.class, annotation -> SpecExtractorUtil.extractSpecsFromOr((Or)annotation));
        NESTED_SPEC_ANNOTATION_EXTRACTORS.put(Conjunction.class, annotation -> SpecExtractorUtil.extractSpecsFromConjunction((Conjunction)annotation));
        NESTED_SPEC_ANNOTATION_EXTRACTORS.put(Disjunction.class, annotation -> SpecExtractorUtil.extractSpecsFromDisjunction((Disjunction)annotation));
    }
}

