/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.kaczmarzyk.spring.data.jpa.utils.BodyParams;

public class JsonBodyParams
implements BodyParams {
    private static final String DOT_DELIMITER = "\\.";
    private final JsonElement requestBody;

    private JsonBodyParams(JsonElement requestBody) {
        this.requestBody = requestBody;
    }

    public static JsonBodyParams parse(String requestBody) {
        return new JsonBodyParams(JsonParser.parseString((String)requestBody));
    }

    @Override
    public Collection<String> getParamValues(String paramKey) {
        JsonElement value = JsonBodyParams.getElementByKey(this.requestBody, paramKey);
        return value != null ? JsonBodyParams.getJsonElementValues(value) : Collections.emptyList();
    }

    private static JsonElement getElementByKey(JsonElement rootElement, String key) {
        if (rootElement == null) {
            return JsonNull.INSTANCE;
        }
        String[] keyParts = key.split(DOT_DELIMITER, 2);
        if (!rootElement.isJsonObject()) {
            throw new JsonParseException("Failed parse JSON node with key " + keyParts[0] + ". Should be JSON object");
        }
        boolean isLastKey = keyParts.length == 1;
        JsonElement childElement = rootElement.getAsJsonObject().get(keyParts[0]);
        return isLastKey ? childElement : JsonBodyParams.getElementByKey(childElement, keyParts[1]);
    }

    private static Collection<String> getJsonElementValues(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            throw new JsonParseException("Value by key should be primitive or array primitives. Found: " + jsonElement);
        }
        if (jsonElement.isJsonArray()) {
            return JsonBodyParams.getJsonArrayValues(jsonElement.getAsJsonArray());
        }
        if (jsonElement.isJsonPrimitive()) {
            return Collections.singletonList(jsonElement.getAsJsonPrimitive().getAsString());
        }
        return Collections.emptyList();
    }

    private static Collection<String> getJsonArrayValues(JsonArray jsonArray) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonElement element : jsonArray) {
            if (!element.isJsonPrimitive()) {
                throw new IllegalArgumentException("Array by key contains not primitives. Array: " + jsonArray);
            }
            result.add(element.getAsJsonPrimitive().getAsString());
        }
        return result;
    }
}

