/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.utils;

import java.util.HashMap;
import java.util.Map;
import net.kaczmarzyk.spring.data.jpa.web.ProcessingContext;
import net.kaczmarzyk.spring.data.jpa.web.SpecificationFactory;
import net.kaczmarzyk.spring.data.jpa.web.StandaloneProcessingContext;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationBuilder<T extends Specification> {
    private SpecificationFactory specificationFactory = new SpecificationFactory(null, null);
    private Class<T> specInterface;
    private Map<String, String[]> fallbackSpecificationParamValues = new HashMap<String, String[]>();
    private Map<String, String> pathVars = new HashMap<String, String>();
    private Map<String, String[]> params = new HashMap<String, String[]>();
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String[]> bodyParams = new HashMap<String, String[]>();

    private SpecificationBuilder(Class<T> specInterface) {
        this.specInterface = specInterface;
    }

    public static <T extends Specification<?>> SpecificationBuilder<T> specification(Class<T> specInterface) {
        return new SpecificationBuilder<T>(specInterface);
    }

    public SpecificationBuilder<T> withSpecificationFactory(SpecificationFactory specificationFactory) {
        this.specificationFactory = specificationFactory;
        return this;
    }

    public SpecificationBuilder<T> withArg(String arg, String ... values) {
        this.fallbackSpecificationParamValues.put(arg, values);
        return this;
    }

    public SpecificationBuilder<T> withParam(String param, String ... values) {
        this.params.put(param, values);
        return this;
    }

    public SpecificationBuilder<T> withPathVar(String pathVar, String value) {
        this.pathVars.put(pathVar, value);
        return this;
    }

    public SpecificationBuilder<T> withHeader(String header, String value) {
        this.headers.put(header, value);
        return this;
    }

    public SpecificationBuilder<T> withJsonBodyParam(String jsonPath, String ... values) {
        this.bodyParams.put(jsonPath, values);
        return this;
    }

    public T build() {
        ProcessingContext context = this.createContext();
        return (T)this.specificationFactory.createSpecificationDependingOn(context);
    }

    private ProcessingContext createContext() {
        return new StandaloneProcessingContext(this.specInterface, this.fallbackSpecificationParamValues, this.pathVars, this.params, this.headers, this.bodyParams);
    }
}

