/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import net.kaczmarzyk.spring.data.jpa.web.DefaultQueryContext;
import net.kaczmarzyk.spring.data.jpa.web.InvalidPathVariableRequestedException;
import net.kaczmarzyk.spring.data.jpa.web.ProcessingContext;

public class StandaloneProcessingContext
implements ProcessingContext {
    private Class<?> specInterface;
    private Map<String, String[]> fallbackArgumentValues;
    private Map<String, String> pathVariableArgs;
    private Map<String, String[]> parameterArgs;
    private Map<String, String> headerArgs;
    private Map<String, String[]> bodyParams;
    private QueryContext queryContext;

    public StandaloneProcessingContext(Class<?> specInterface, Map<String, String[]> fallbackArgumentValues, Map<String, String> pathVariableArgs, Map<String, String[]> parameterArgs, Map<String, String> headerArgs, Map<String, String[]> bodyParams) {
        this.specInterface = specInterface;
        this.fallbackArgumentValues = fallbackArgumentValues;
        this.pathVariableArgs = pathVariableArgs;
        this.parameterArgs = parameterArgs;
        this.headerArgs = headerArgs;
        this.bodyParams = bodyParams;
        this.queryContext = new DefaultQueryContext();
    }

    @Override
    public Class<?> getParameterType() {
        return this.specInterface;
    }

    @Override
    public Annotation[] getParameterAnnotations() {
        return new Annotation[0];
    }

    @Override
    public QueryContext queryContext() {
        return this.queryContext;
    }

    @Override
    public String getRequestHeaderValue(String headerKey) {
        return this.headerArgs.containsKey(headerKey) ? this.headerArgs.get(headerKey) : this.getFallbackValue(headerKey);
    }

    @Override
    public String[] getParameterValues(String webParamName) {
        return this.parameterArgs.containsKey(webParamName) ? this.parameterArgs.get(webParamName) : this.getFallbackValues(webParamName);
    }

    @Override
    public String getPathVariableValue(String pathVariableName) {
        String fallbackValue = this.getFallbackValue(pathVariableName);
        if (this.pathVariableArgs.containsKey(pathVariableName)) {
            return this.pathVariableArgs.get(pathVariableName);
        }
        if (Objects.nonNull(fallbackValue)) {
            return fallbackValue;
        }
        throw new InvalidPathVariableRequestedException(pathVariableName);
    }

    @Override
    public String[] getBodyParamValues(String bodyParamName) {
        return this.bodyParams.containsKey(bodyParamName) ? this.bodyParams.get(bodyParamName) : this.getFallbackValues(bodyParamName);
    }

    private String[] getFallbackValues(String argName) {
        return this.fallbackArgumentValues.get(argName);
    }

    private String getFallbackValue(String argName) {
        if (!this.fallbackArgumentValues.containsKey(argName) || this.fallbackArgumentValues.get(argName).length == 0) {
            return null;
        }
        return this.fallbackArgumentValues.get(argName)[0];
    }
}

