/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.web;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import net.kaczmarzyk.spring.data.jpa.utils.BodyParams;
import net.kaczmarzyk.spring.data.jpa.utils.IOUtils;
import net.kaczmarzyk.spring.data.jpa.utils.JsonBodyParams;
import net.kaczmarzyk.spring.data.jpa.utils.PathVariableResolver;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import net.kaczmarzyk.spring.data.jpa.web.DefaultQueryContext;
import net.kaczmarzyk.spring.data.jpa.web.InvalidPathVariableRequestedException;
import net.kaczmarzyk.spring.data.jpa.web.ProcessingContext;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestProcessingContext
implements ProcessingContext {
    private final MethodParameter methodParameter;
    private final NativeWebRequest webRequest;
    private BodyParams bodyParams;
    private Map<String, String> resolvedPathVariables;
    private QueryContext queryContext;

    public WebRequestProcessingContext(MethodParameter methodParameter, NativeWebRequest webRequest) {
        this.methodParameter = methodParameter;
        this.webRequest = webRequest;
        this.queryContext = new DefaultQueryContext();
    }

    @Override
    public Class<?> getParameterType() {
        return this.methodParameter.getParameterType();
    }

    @Override
    public Annotation[] getParameterAnnotations() {
        return this.methodParameter.getParameterAnnotations();
    }

    @Override
    public String[] getParameterValues(String webParamName) {
        return this.webRequest.getParameterValues(webParamName);
    }

    @Override
    public QueryContext queryContext() {
        return this.queryContext;
    }

    @Override
    public String getPathVariableValue(String pathVariableName) {
        String value;
        if (this.resolvedPathVariables == null) {
            this.resolvedPathVariables = PathVariableResolver.resolvePathVariables(this.webRequest, this.methodParameter);
        }
        if ((value = this.resolvedPathVariables.get(pathVariableName)) != null) {
            return value;
        }
        throw new InvalidPathVariableRequestedException(pathVariableName);
    }

    @Override
    public String getRequestHeaderValue(String headerKey) {
        return this.webRequest.getHeader(headerKey);
    }

    @Override
    public String[] getBodyParamValues(String bodyParamName) {
        return this.getBodyParams().getParamValues(bodyParamName).toArray(new String[0]);
    }

    private BodyParams getBodyParams() {
        if (Objects.isNull(this.bodyParams)) {
            String contentType = this.getRequestHeaderValue("Content-Type");
            if (contentType.equals("application/json")) {
                this.bodyParams = JsonBodyParams.parse(this.getRequestBody());
            } else {
                throw new IllegalArgumentException("Content-type not supported, content-type=" + contentType);
            }
        }
        return this.bodyParams;
    }

    private String getRequestBody() {
        try {
            HttpServletRequest request = (HttpServletRequest)this.webRequest.getNativeRequest(HttpServletRequest.class);
            if (request == null) {
                throw new IllegalStateException("Request body not present");
            }
            return IOUtils.toString((InputStream)request.getInputStream(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read request body. Detail: " + ex.getMessage());
        }
    }
}

