/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.PathSpecification;
import net.kaczmarzyk.spring.data.jpa.utils.Converter;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public abstract class ComparableSpecification<T>
extends PathSpecification<T> {
    private static final long serialVersionUID = 1L;
    private String comparedTo;
    private Converter converter;

    public ComparableSpecification(QueryContext queryContext, String path, String[] httpParamValues, Converter converter) {
        super(queryContext, path);
        if (httpParamValues == null || httpParamValues.length != 1) {
            throw new IllegalArgumentException("expected one http-param, but was " + Arrays.toString(httpParamValues));
        }
        this.comparedTo = httpParamValues[0];
        this.converter = converter;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Path rootPath = this.path(root);
        Class typeOnPath = rootPath.getJavaType();
        return this.makePredicate(cb, (Expression)rootPath, (Comparable)((Comparable)this.converter.convert(this.comparedTo, typeOnPath)));
    }

    protected abstract <Y extends Comparable<? super Y>> Predicate makePredicate(CriteriaBuilder var1, Expression<? extends Y> var2, Y var3);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComparableSpecification that = (ComparableSpecification)o;
        return Objects.equals(this.comparedTo, that.comparedTo) && Objects.equals(this.converter, that.converter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.comparedTo, this.converter);
    }
}

