/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.Fake;
import net.kaczmarzyk.spring.data.jpa.domain.Join;
import net.kaczmarzyk.spring.data.jpa.utils.JoinPathUtils;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class JoinFetch<T>
implements Specification<T>,
Fake {
    private static final long serialVersionUID = 1L;
    private QueryContext context;
    private List<String> pathsToFetch;
    private String alias;
    private JoinType joinType;
    private boolean distinct;

    public JoinFetch(QueryContext queryContext, String[] pathsToFetch, JoinType joinType, boolean distinct) {
        this(queryContext, pathsToFetch, "", joinType, distinct);
    }

    public JoinFetch(QueryContext queryContext, String[] pathsToFetch, String alias, JoinType joinType, boolean distinct) {
        this.context = queryContext;
        this.pathsToFetch = Arrays.asList(pathsToFetch);
        this.alias = alias;
        this.joinType = joinType;
        this.distinct = distinct;
        if (!alias.isEmpty() && pathsToFetch.length != 1) {
            throw new IllegalArgumentException("Join fetch alias can be defined only for join fetch with a single path! Remove alias from the annotation or repeat @JoinFetch annotation for every path and use unique alias for each join.");
        }
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        query.distinct(this.distinct);
        if (!Number.class.isAssignableFrom(query.getResultType())) {
            if (this.pathsToFetch.size() == 1) {
                String pathToFetch = this.pathsToFetch.get(0);
                if (JoinPathUtils.pathToJoinContainsAlias(pathToFetch)) {
                    String[] pathToJoinFetchOnSplittedByDot = JoinPathUtils.pathToJoinSplittedByDot(pathToFetch);
                    String alias = pathToJoinFetchOnSplittedByDot[0];
                    String path = pathToJoinFetchOnSplittedByDot[1];
                    Fetch<?, ?> evaluatedJoinFetchForGivenAlias = this.context.getEvaluatedJoinFetch(alias);
                    if (evaluatedJoinFetchForGivenAlias == null) {
                        throw new IllegalArgumentException("Join fetch definition with alias: '" + alias + "' not found! Make sure that join with the alias '" + alias + "' is defined before the join with path: '" + pathToFetch + "'");
                    }
                    Fetch joinFetch = evaluatedJoinFetchForGivenAlias.fetch(path, this.joinType);
                    if (StringUtils.isNotBlank((CharSequence)this.alias)) {
                        this.context.putEvaluatedJoinFetch(this.alias, joinFetch);
                    }
                } else {
                    Fetch evaluated = root.fetch(pathToFetch, this.joinType);
                    this.context.putEvaluatedJoinFetch(this.alias, evaluated);
                }
            } else {
                for (String path : this.pathsToFetch) {
                    root.fetch(path, this.joinType);
                }
            }
        } else if (!this.alias.isEmpty()) {
            String pathToJoin = this.pathsToFetch.iterator().next();
            Join<T> regularJoin = new Join<T>(this.context, pathToJoin, this.alias, this.joinType, this.distinct);
            return regularJoin.toPredicate(root, query, cb);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinFetch joinFetch = (JoinFetch)o;
        return this.distinct == joinFetch.distinct && Objects.equals(this.context, joinFetch.context) && Objects.equals(this.pathsToFetch, joinFetch.pathsToFetch) && Objects.equals(this.alias, joinFetch.alias) && this.joinType == joinFetch.joinType;
    }

    public int hashCode() {
        return Objects.hash(this.context, this.pathsToFetch, this.alias, this.joinType, this.distinct);
    }

    public String toString() {
        return "JoinFetch[pathsToFetch=" + this.pathsToFetch + ", joinType=" + this.joinType + "]";
    }
}

