/*
 * Decompiled with CFR 0.152.
 */
package net.kaczmarzyk.spring.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Locale;
import java.util.Objects;
import net.kaczmarzyk.spring.data.jpa.domain.LocaleAware;
import net.kaczmarzyk.spring.data.jpa.domain.NotLike;
import net.kaczmarzyk.spring.data.jpa.utils.QueryContext;

public class NotLikeIgnoreCase<T>
extends NotLike<T>
implements LocaleAware {
    private static final long serialVersionUID = 1L;
    private Locale locale;

    public NotLikeIgnoreCase(QueryContext queryContext, String path, String ... args) {
        super(queryContext, path, args);
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        return builder.not((Expression)builder.like(builder.upper(this.path(root)), this.pattern.toUpperCase(this.locale)));
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.locale);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotLikeIgnoreCase other = (NotLikeIgnoreCase)obj;
        return Objects.equals(this.locale, other.locale);
    }

    @Override
    public String toString() {
        return "NotLikeIgnoreCase [locale=" + this.locale + ", pattern=" + this.pattern + ", path=" + this.path + "]";
    }
}

