/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser;
import net.liftweb.json.JsonParser$Buffer$;
import net.liftweb.json.JsonParser$CloseArr$;
import net.liftweb.json.JsonParser$CloseObj$;
import net.liftweb.json.JsonParser$End$;
import net.liftweb.json.JsonParser$NullVal$;
import net.liftweb.json.JsonParser$OpenArr$;
import net.liftweb.json.JsonParser$OpenObj$;
import net.liftweb.json.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigInt;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class JsonParser$ {
    public static JsonParser$ MODULE$;
    private final int[] HexChars;
    private final Function1<JsonParser.Parser, JsonAST.JValue> astParser;
    public final char net$liftweb$json$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(String s) {
        return this.parse(new JsonParser.Buffer(new StringReader(s), false, JsonParser$Buffer$.MODULE$.$lessinit$greater$default$3()));
    }

    public JsonAST.JValue parse(Reader s, boolean closeAutomatically) {
        return this.parse(new JsonParser.Buffer(s, closeAutomatically, JsonParser$Buffer$.MODULE$.$lessinit$greater$default$3()));
    }

    public Option<JsonAST.JValue> parseOpt(String s) {
        Option<JsonAST.JValue> option;
        try {
            option = this.parse(s).toOpt();
        }
        catch (Exception e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<JsonAST.JValue> parseOpt(Reader s, boolean closeAutomatically) {
        Option<JsonAST.JValue> option;
        try {
            option = this.parse(s, closeAutomatically).toOpt();
        }
        catch (Exception e) {
            option = None$.MODULE$;
        }
        return option;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        return this.parse((Reader)new StringReader(s), p);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        return (A)p.apply((Object)new JsonParser.Parser(new JsonParser.Buffer(s, false, JsonParser$Buffer$.MODULE$.$lessinit$greater$default$3())));
    }

    public JsonAST.JValue parse(JsonParser.Buffer buf) {
        JsonAST.JValue jValue;
        try {
            try {
                jValue = (JsonAST.JValue)this.astParser().apply((Object)new JsonParser.Parser(buf));
            }
            catch (JsonParser.ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JsonParser.ParseException("parsing failed", e);
            }
        }
        finally {
            buf.release();
        }
        return jValue;
    }

    public boolean parse$default$2() {
        return true;
    }

    public boolean parseOpt$default$2() {
        return true;
    }

    public String unquote(String string) {
        return this.net$liftweb$json$JsonParser$$unquote(new JsonParser.Buffer(new StringReader(string), false, JsonParser$Buffer$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    public String net$liftweb$json$JsonParser$$unquote(JsonParser.Buffer buf) {
        void var3_3;
        buf.eofIsFailure_$eq(true);
        buf.mark();
        int c = buf.next();
        String forcedReturn = null;
        block3: while (c != 34) {
            int n = c;
            switch (n) {
                case 92: {
                    forcedReturn = this.unquote0$1(buf);
                    c = 34;
                    continue block3;
                }
            }
            c = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return forcedReturn == null ? new String(buf.substring(buf.substring$default$1())) : var3_3;
    }

    public double parseDouble(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).toDouble();
    }

    private Function1<JsonParser.Parser, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    private final String unquote0$1(JsonParser.Buffer buf) {
        StringBuilder builder = buf.builder();
        builder.delete(0, builder.length());
        int c = 92;
        while (c != 34) {
            if (c == 92) {
                buf.substring(true);
                char c2 = buf.next();
                switch (c2) {
                    case '\"': {
                        StringBuilder stringBuilder = builder.append('\"');
                        break;
                    }
                    case '\\': {
                        StringBuilder stringBuilder = builder.append('\\');
                        break;
                    }
                    case '/': {
                        StringBuilder stringBuilder = builder.append('/');
                        break;
                    }
                    case 'b': {
                        StringBuilder stringBuilder = builder.append('\b');
                        break;
                    }
                    case 'f': {
                        StringBuilder stringBuilder = builder.append('\f');
                        break;
                    }
                    case 'n': {
                        StringBuilder stringBuilder = builder.append('\n');
                        break;
                    }
                    case 'r': {
                        StringBuilder stringBuilder = builder.append('\r');
                        break;
                    }
                    case 't': {
                        StringBuilder stringBuilder = builder.append('\t');
                        break;
                    }
                    case 'u': {
                        int finalChar = 0;
                        char[] chars = new char[]{buf.next(), buf.next(), buf.next(), buf.next()};
                        for (int i = 0; i < chars.length; ++i) {
                            finalChar = finalChar << 4 | this.HexChars[chars[i]];
                        }
                        StringBuilder stringBuilder = builder.appendCodePoint((char)finalChar);
                        break;
                    }
                    default: {
                        StringBuilder stringBuilder = builder.append('\\');
                        break;
                    }
                }
                buf.mark();
            }
            c = buf.next();
        }
        buf.substring(true);
        return builder.toString();
    }

    private static final JsonAST.JValue toJValue$1(Object x, JsonParser.Parser p$1) {
        JsonAST.JValue jValue;
        Object object = x;
        if (object instanceof JsonAST.JValue) {
            JsonAST.JValue jValue2;
            jValue = jValue2 = (JsonAST.JValue)object;
        } else if (object instanceof JsonParser.IntermediateJObject) {
            JsonParser.IntermediateJObject intermediateJObject = (JsonParser.IntermediateJObject)object;
            jValue = package$.MODULE$.JObject().apply((List<JsonAST.JField>)intermediateJObject.fields().result());
        } else if (object instanceof JsonParser.IntermediateJArray) {
            JsonParser.IntermediateJArray intermediateJArray = (JsonParser.IntermediateJArray)object;
            jValue = package$.MODULE$.JArray().apply((List<JsonAST.JValue>)intermediateJArray.bits().result());
        } else {
            throw p$1.fail(new StringBuilder(17).append("unexpected field ").append(x).toString(), p$1.fail$default$2());
        }
        return jValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void closeBlock$1(Object v, JsonParser.Parser p$1, JsonParser.ValStack vals$1, ObjectRef root$1) {
        Object a;
        Object o;
        boolean bl = false;
        Some some = null;
        Option<Object> option = vals$1.peekOption();
        if (option instanceof Some) {
            JsonAST.JField jField;
            String name;
            bl = true;
            some = (Some)option;
            Object object = some.value();
            if (object instanceof JsonAST.JField && (name = (jField = (JsonAST.JField)object).name()) != null) {
                String string = name;
                vals$1.pop(JsonAST.JField.class);
                JsonParser.IntermediateJObject obj = vals$1.peek(JsonParser.IntermediateJObject.class);
                obj.fields().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonAST.JField[]{package$.MODULE$.JField().apply(string, JsonParser$.toJValue$1(v, p$1))}));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (o = some.value()) instanceof JsonParser.IntermediateJObject) {
            JsonParser.IntermediateJObject intermediateJObject = (JsonParser.IntermediateJObject)o;
            intermediateJObject.fields().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonAST.JField[]{vals$1.peek(JsonAST.JField.class)}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl && (a = some.value()) instanceof JsonParser.IntermediateJArray) {
            JsonParser.IntermediateJArray intermediateJArray = (JsonParser.IntermediateJArray)a;
            intermediateJArray.bits().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonAST.JValue[]{JsonParser$.toJValue$1(v, p$1)}));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Object x = some.value();
            throw p$1.fail(new StringBuilder(40).append("expected field, array or object but got ").append(x).toString(), p$1.fail$default$2());
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        root$1.elem = new Some((Object)JsonParser$.toJValue$1(v, p$1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void newValue$1(JsonAST.JValue v, JsonParser.ValStack vals$1, JsonParser.Parser p$1, ObjectRef root$1) {
        if (!vals$1.isEmpty()) {
            Object object = vals$1.peekAny();
            if (object instanceof JsonAST.JField) {
                JsonAST.JField jField = (JsonAST.JField)object;
                String name = jField.name();
                vals$1.pop(JsonAST.JField.class);
                JsonParser.IntermediateJObject obj = vals$1.peek(JsonParser.IntermediateJObject.class);
                obj.fields().$plus$eq((Object)package$.MODULE$.JField().apply(name, v));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            } else {
                if (!(object instanceof JsonParser.IntermediateJArray)) throw p$1.fail(new StringBuilder(32).append("expected field or array but got ").append(object).toString(), p$1.fail$default$2());
                JsonParser.IntermediateJArray intermediateJArray = (JsonParser.IntermediateJArray)object;
                intermediateJArray.bits().$plus$eq((Object)v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            vals$1.push(v);
            root$1.elem = new Some((Object)v);
        }
    }

    /*
     * WARNING - void declaration
     */
    private JsonParser$() {
        void var1_1;
        int i;
        MODULE$ = this;
        int[] chars = new int[128];
        for (i = 0; i < 10; ++i) {
            chars[i + 48] = i;
        }
        for (i = 0; i < 16; ++i) {
            chars[i + 97] = 10 + i;
            chars[i + 65] = 10 + i;
        }
        this.HexChars = var1_1;
        this.astParser = (Function1 & Serializable & scala.Serializable)p -> {
            JsonParser$End$ jsonParser$End$;
            JsonParser.Token token;
            JsonParser.ValStack vals = new JsonParser.ValStack((JsonParser.Parser)p);
            JsonParser.Token token2 = null;
            ObjectRef root = ObjectRef.create((Object)None$.MODULE$);
            do {
                BoxedUnit boxedUnit;
                JsonParser.Token token3;
                if (JsonParser$OpenObj$.MODULE$.equals(token3 = (token2 = p.nextToken()))) {
                    vals.push(new JsonParser.IntermediateJObject((ListBuffer<JsonAST.JField>)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.FieldStart) {
                    JsonParser.FieldStart fieldStart = (JsonParser.FieldStart)token3;
                    String name = fieldStart.name();
                    vals.push(package$.MODULE$.JField().apply(name, null));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.StringVal) {
                    JsonParser.StringVal stringVal = (JsonParser.StringVal)token3;
                    String x = stringVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JString().apply(x), vals, p, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.IntVal) {
                    JsonParser.IntVal intVal = (JsonParser.IntVal)token3;
                    BigInt x = intVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JInt().apply(x), vals, p, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.DoubleVal) {
                    JsonParser.DoubleVal doubleVal = (JsonParser.DoubleVal)token3;
                    double x = doubleVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JDouble().apply(x), vals, p, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (token3 instanceof JsonParser.BoolVal) {
                    JsonParser.BoolVal boolVal = (JsonParser.BoolVal)token3;
                    boolean x = boolVal.value();
                    JsonParser$.newValue$1(package$.MODULE$.JBool().apply(x), vals, p, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$NullVal$.MODULE$.equals(token3)) {
                    JsonParser$.newValue$1(package$.MODULE$.JNull(), vals, p, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$CloseObj$.MODULE$.equals(token3)) {
                    JsonParser$.closeBlock$1(vals.popAny(), p, vals, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$OpenArr$.MODULE$.equals(token3)) {
                    vals.push(new JsonParser.IntermediateJArray((ListBuffer<JsonAST.JValue>)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$CloseArr$.MODULE$.equals(token3)) {
                    JsonParser$.closeBlock$1(vals.popAny(), p, vals, root);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (JsonParser$End$.MODULE$.equals(token3)) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)token3);
                }
                token = token2;
                jsonParser$End$ = JsonParser$End$.MODULE$;
            } while (token == null ? jsonParser$End$ != null : !token.equals(jsonParser$End$));
            return (JsonAST.JValue)((Option)root.elem).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.JNothing());
        };
        this.net$liftweb$json$JsonParser$$EOF = (char)-1;
    }
}

