/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import net.lightbody.bmp.proxy.http.RequestInfo;
import org.java_bandwidthlimiter.StreamManager;

public class SimulatedSocket
extends Socket {
    private final StreamManager streamManager;

    public SimulatedSocket(StreamManager streamManager) {
        this.streamManager = streamManager;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        long start = System.nanoTime();
        super.connect(endpoint);
        long end = System.nanoTime();
        this.simulateLatency(start, end, this.streamManager);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        long start = System.nanoTime();
        super.connect(endpoint, timeout);
        long end = System.nanoTime();
        this.simulateLatency(start, end, this.streamManager);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.streamManager.registerStream(super.getInputStream());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.streamManager.registerStream(super.getOutputStream());
    }

    private void simulateLatency(long start, long end, StreamManager streamManager) {
        long realEnd = end;
        long connectReal = end - start;
        if (connectReal < streamManager.getLatency()) {
            try {
                Thread.sleep(streamManager.getLatency() - connectReal);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            end = System.nanoTime();
        }
        RequestInfo.get().latency(start, realEnd);
        RequestInfo.get().connect(start, end);
    }
}

