/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import java.nio.charset.Charset;
import net.lightbody.bmp.util.BrowserMobHttpUtil;

public class HttpObjectUtil {
    public static void replaceTextHttpEntityBody(FullHttpMessage message, String newContents) {
        String contentTypeHeader = message.headers().get("Content-Type");
        Charset messageCharset = BrowserMobHttpUtil.deriveCharsetFromContentTypeHeader(contentTypeHeader);
        byte[] contentBytes = newContents.getBytes(messageCharset);
        HttpObjectUtil.replaceBinaryHttpEntityBody(message, contentBytes);
    }

    public static void replaceBinaryHttpEntityBody(FullHttpMessage message, byte[] newBinaryContents) {
        message.content().resetWriterIndex();
        message.content().ensureWritable(newBinaryContents.length, true);
        message.content().writeBytes(newBinaryContents);
        message.headers().set("Content-Length", (Object)newBinaryContents.length);
    }

    public static String extractHttpEntityBody(HttpContent httpContent, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("No charset specified when extracting the contents of an HTTP message");
        }
        byte[] contentBytes = BrowserMobHttpUtil.extractReadableBytes(httpContent.content());
        return new String(contentBytes, charset);
    }

    public static String extractHttpEntityBody(FullHttpMessage httpMessage) {
        Charset charset = HttpObjectUtil.getCharsetFromMessage((HttpMessage)httpMessage);
        return HttpObjectUtil.extractHttpEntityBody((HttpContent)httpMessage, charset);
    }

    public static Charset getCharsetFromMessage(HttpMessage httpMessage) {
        String contentTypeHeader = HttpHeaders.getHeader((HttpMessage)httpMessage, (String)"Content-Type");
        return BrowserMobHttpUtil.deriveCharsetFromContentTypeHeader(contentTypeHeader);
    }

    public static byte[] extractBinaryHttpEntityBody(HttpContent httpContent) {
        return BrowserMobHttpUtil.extractReadableBytes(httpContent.content());
    }
}

