/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.logstash.logback.decorate;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingJsonFactory;

/**
 * Combines a list of decorators into a single decorator, so multiple decorators can be used together.
 */
public class CompositeJsonFactoryDecorator implements JsonFactoryDecorator {
    
    private final List<JsonFactoryDecorator> decorators = new ArrayList<JsonFactoryDecorator>();

    @Override
    @Deprecated
    public MappingJsonFactory decorate(MappingJsonFactory factory) {
        return (MappingJsonFactory) decorate((JsonFactory) factory);
    }

    @Override
    public JsonFactory decorate(JsonFactory factory) {
        JsonFactory decoratedFactory = factory;
        for (JsonFactoryDecorator decorator : decorators) {
            decoratedFactory = decorator.decorate(decoratedFactory);
        }
        return decoratedFactory;
    }
    
    public void addDecorator(JsonFactoryDecorator decorator) {
        decorators.add(decorator);
    }
    
    public boolean removeDecorator(JsonFactoryDecorator decorator) {
        return decorators.remove(decorator);
    }

}
