/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashCommonFieldNames;
import net.logstash.logback.util.TimeZoneUtils;

public abstract class AbstractFormattedTimestampJsonProvider<Event extends DeferredProcessingAware, FieldNames extends LogstashCommonFieldNames>
extends AbstractFieldJsonProvider<Event>
implements FieldNamesAware<FieldNames> {
    public static final String FIELD_TIMESTAMP = "@timestamp";
    public static final String UNIX_TIMESTAMP_AS_NUMBER = "[UNIX_TIMESTAMP_AS_NUMBER]";
    public static final String UNIX_TIMESTAMP_AS_STRING = "[UNIX_TIMESTAMP_AS_STRING]";
    private static final String DEFAULT_PATTERN = "[ISO_OFFSET_DATE_TIME]";
    public static final String DEFAULT_TIMEZONE_KEYWORD = "[DEFAULT]";
    private String pattern = "[ISO_OFFSET_DATE_TIME]";
    private TimeZone timeZone = TimeZone.getDefault();
    private TimestampWriter timestampWriter;

    public AbstractFormattedTimestampJsonProvider() {
        this.setFieldName(FIELD_TIMESTAMP);
        this.updateTimestampWriter();
    }

    @Override
    public void setFieldNames(FieldNames fieldNames) {
        this.setFieldName(((LogstashCommonFieldNames)fieldNames).getTimestamp());
    }

    @Override
    public void writeTo(JsonGenerator generator, Event event) throws IOException {
        this.timestampWriter.writeTo(generator, this.getFieldName(), this.getTimestampAsMillis(event));
    }

    protected String getFormattedTimestamp(Event event) {
        return this.timestampWriter.getTimestampAsString(this.getTimestampAsMillis(event));
    }

    protected abstract long getTimestampAsMillis(Event var1);

    private void updateTimestampWriter() {
        block10: {
            if (UNIX_TIMESTAMP_AS_NUMBER.equals(this.pattern)) {
                this.timestampWriter = new NumberTimestampWriter();
            } else if (UNIX_TIMESTAMP_AS_STRING.equals(this.pattern)) {
                this.timestampWriter = new StringTimestampWriter();
            } else {
                if (this.pattern.startsWith("[") && this.pattern.endsWith("]")) {
                    String constant = this.pattern.substring("[".length(), this.pattern.length() - "]".length());
                    try {
                        Field field = DateTimeFormatter.class.getField(constant);
                        if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && field.getType().equals(DateTimeFormatter.class)) {
                            try {
                                DateTimeFormatter formatter = (DateTimeFormatter)field.get(null);
                                this.timestampWriter = new PatternTimestampWriter(formatter.withZone(this.timeZone.toZoneId()));
                                break block10;
                            }
                            catch (IllegalAccessException e) {
                                throw new IllegalArgumentException(String.format("Unable to get value of constant named %s in %s", constant, DateTimeFormatter.class), e);
                            }
                        }
                        throw new IllegalArgumentException(String.format("Field named %s in %s is not a constant %s", constant, DateTimeFormatter.class, DateTimeFormatter.class));
                    }
                    catch (NoSuchFieldException e) {
                        throw new IllegalArgumentException(String.format("No constant named %s found in %s", constant, DateTimeFormatter.class), e);
                    }
                }
                this.timestampWriter = new PatternTimestampWriter(DateTimeFormatter.ofPattern(this.pattern).withZone(this.timeZone.toZoneId()));
            }
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.updateTimestampWriter();
    }

    public String getTimeZone() {
        return this.timeZone.getID();
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone == null || timeZone.trim().isEmpty() || DEFAULT_TIMEZONE_KEYWORD.equalsIgnoreCase(timeZone) ? TimeZone.getDefault() : TimeZoneUtils.parseTimeZone(timeZone);
        this.updateTimestampWriter();
    }

    private static class StringTimestampWriter
    implements TimestampWriter {
        private StringTimestampWriter() {
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, long timestampInMillis) throws IOException {
            JsonWritingUtils.writeStringField(generator, fieldName, this.getTimestampAsString(timestampInMillis));
        }

        @Override
        public String getTimestampAsString(long timestampInMillis) {
            return Long.toString(timestampInMillis);
        }
    }

    private static class NumberTimestampWriter
    implements TimestampWriter {
        private NumberTimestampWriter() {
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, long timestampInMillis) throws IOException {
            JsonWritingUtils.writeNumberField(generator, fieldName, timestampInMillis);
        }

        @Override
        public String getTimestampAsString(long timestampInMillis) {
            return Long.toString(timestampInMillis);
        }
    }

    private static class PatternTimestampWriter
    implements TimestampWriter {
        private final DateTimeFormatter formatter;

        PatternTimestampWriter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        @Override
        public void writeTo(JsonGenerator generator, String fieldName, long timestampInMillis) throws IOException {
            JsonWritingUtils.writeStringField(generator, fieldName, this.getTimestampAsString(timestampInMillis));
        }

        @Override
        public String getTimestampAsString(long timestampInMillis) {
            return this.formatter.format(Instant.ofEpochMilli(timestampInMillis));
        }
    }

    private static interface TimestampWriter {
        public void writeTo(JsonGenerator var1, String var2, long var3) throws IOException;

        public String getTimestampAsString(long var1);
    }
}

