/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class JsonWritingUtils {
    public static void writeMapEntries(JsonGenerator generator, Map<?, ?> map) throws IOException, JsonMappingException {
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                generator.writeFieldName(entry.getKey().toString());
                generator.writeObject(entry.getValue());
            }
        }
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map) throws IOException, JsonMappingException {
        JsonWritingUtils.writeMapStringFields(generator, fieldName, map, false);
    }

    public static void writeMapStringFields(JsonGenerator generator, String fieldName, Map<String, String> map, boolean lowerCaseKeys) throws IOException, JsonMappingException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && map != null && !map.isEmpty()) {
            generator.writeObjectFieldStart(fieldName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey() != null && lowerCaseKeys ? entry.getKey().toLowerCase() : entry.getKey();
                JsonWritingUtils.writeStringField(generator, key, entry.getValue());
            }
            generator.writeEndObject();
        }
    }

    public static void writeStringArrayField(JsonGenerator generator, String fieldName, String[] fieldValues) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValues != null && fieldValues.length > 0) {
            generator.writeArrayFieldStart(fieldName);
            for (String fieldValue : fieldValues) {
                generator.writeString(fieldValue);
            }
            generator.writeEndArray();
        }
    }

    public static void writeStringField(JsonGenerator generator, String fieldName, String fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName) && fieldValue != null) {
            generator.writeStringField(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, int fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    public static void writeNumberField(JsonGenerator generator, String fieldName, long fieldValue) throws IOException {
        if (JsonWritingUtils.shouldWriteField(fieldName)) {
            generator.writeNumberField(fieldName, fieldValue);
        }
    }

    public static boolean shouldWriteField(String fieldName) {
        return fieldName != null && !fieldName.equals("[ignore]");
    }

    public static void writeSimpleObject(JsonGenerator generator, Object value) throws IOException {
        if (value == null) {
            generator.writeNull();
            return;
        }
        if (value instanceof String) {
            generator.writeString((String)value);
            return;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (n instanceof Integer) {
                generator.writeNumber(n.intValue());
                return;
            }
            if (n instanceof Long) {
                generator.writeNumber(n.longValue());
                return;
            }
            if (n instanceof Double) {
                generator.writeNumber(n.doubleValue());
                return;
            }
            if (n instanceof Float) {
                generator.writeNumber(n.floatValue());
                return;
            }
            if (n instanceof Short) {
                generator.writeNumber(n.shortValue());
                return;
            }
            if (n instanceof Byte) {
                generator.writeNumber((short)n.byteValue());
                return;
            }
            if (n instanceof BigInteger) {
                generator.writeNumber((BigInteger)n);
                return;
            }
            if (n instanceof BigDecimal) {
                generator.writeNumber((BigDecimal)n);
                return;
            }
            if (n instanceof AtomicInteger) {
                generator.writeNumber(((AtomicInteger)n).get());
                return;
            }
            if (n instanceof AtomicLong) {
                generator.writeNumber(((AtomicLong)n).get());
                return;
            }
        }
        if (value instanceof byte[]) {
            generator.writeBinary((byte[])value);
            return;
        }
        if (value instanceof Boolean) {
            generator.writeBoolean(((Boolean)value).booleanValue());
            return;
        }
        if (value instanceof AtomicBoolean) {
            generator.writeBoolean(((AtomicBoolean)value).get());
            return;
        }
        if (value instanceof JsonNode) {
            JsonNode node = (JsonNode)value;
            if (node instanceof NullNode) {
                generator.writeNull();
            } else {
                node.serialize(generator, null);
            }
            return;
        }
        throw new IllegalArgumentException("Can only serialize simple wrapper types (type passed " + value.getClass().getName() + ")");
    }
}

