/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import net.masterthought.cucumber.json.support.Argument;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StepNameFormatter {
    public static final StepNameFormatter INSTANCE = new StepNameFormatter();

    public static String format(String stepName, Argument[] arguments, String preArgument, String postArgument) {
        if (ArrayUtils.isEmpty((Object[])arguments)) {
            return StringEscapeUtils.escapeHtml((String)stepName);
        }
        Object[] chars = StepNameFormatter.splitIntoCharacters(stepName);
        StepNameFormatter.escape((String[])chars);
        StepNameFormatter.surroundArguments(arguments, preArgument, postArgument, (String[])chars);
        return StringUtils.join((Object[])chars);
    }

    private static String[] splitIntoCharacters(String str) {
        return str.split("(?!^)");
    }

    private static void surroundArguments(Argument[] arguments, String preArgument, String postArgument, String[] chars) {
        for (Argument argument : arguments) {
            if (!StepNameFormatter.isValidArgument(argument)) continue;
            int start = argument.getOffset();
            int end = start + argument.getVal().length() - 1;
            chars[start] = preArgument + chars[start];
            chars[end] = chars[end] + postArgument;
        }
    }

    private static boolean isValidArgument(Argument argument) {
        return argument.getOffset() != null && argument.getVal().length() > 0;
    }

    private static void escape(String[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = StringEscapeUtils.escapeHtml((String)chars[i]);
        }
    }
}

