/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.reducers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.reducers.ReportFeatureMerger;

final class ReportFeatureByIdMerger
implements ReportFeatureMerger {
    ReportFeatureByIdMerger() {
    }

    @Override
    public List<Feature> merge(List<Feature> features) {
        HashMap<String, Feature> mergedFeatures = new HashMap<String, Feature>();
        for (Feature feature : features) {
            Feature mergedFeature = (Feature)mergedFeatures.get(feature.getId());
            if (mergedFeature == null) {
                mergedFeatures.put(feature.getId(), feature);
                continue;
            }
            ((Feature)mergedFeatures.get(feature.getId())).addElements(feature.getElements());
        }
        return new ArrayList<Feature>(mergedFeatures.values());
    }

    @Override
    public boolean test(List<ReducingMethod> reducingMethods) {
        return reducingMethods != null && reducingMethods.contains((Object)ReducingMethod.MERGE_FEATURES_BY_ID);
    }
}

