/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.File;

public class ChecksumFile {
    protected final String basePath;
    protected final File file;
    protected final String extension;
    protected final String classifier;

    public ChecksumFile(String basePath, File file, String extension, String classifier) {
        this.basePath = basePath;
        this.file = file;
        this.extension = extension;
        this.classifier = classifier;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public File getFile() {
        return this.file;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getRelativePath(ChecksumFile file, String subPath) {
        String filePath = file.getFile().getName();
        if (subPath != null && file.getBasePath() != null && !file.getBasePath().isEmpty()) {
            String basePath = file.getBasePath();
            if (!basePath.endsWith(System.getProperty("file.separator"))) {
                basePath = basePath + System.getProperty("file.separator");
            }
            filePath = file.getFile().getPath().replace(basePath, "");
            if (!subPath.isEmpty()) {
                if (!subPath.endsWith(System.getProperty("file.separator"))) {
                    subPath = subPath + System.getProperty("file.separator");
                }
                filePath = filePath.replace(subPath, "");
            }
        }
        return filePath;
    }
}

