/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

/**
 * Contains an HTTP request.
 * In RFC 2616 terms, this object represents data found in the
 * <code>Request</code> body.
 */
public class Request
{
	private final RequestLine requestLine;
	private final MessageHeaders headers;

	/**
	 * Constructs a <code>RequestImpl</code> by parts.
	 */
	public Request(RequestLine requestLine, MessageHeaders headers)
	{
		this.requestLine = requestLine;
		this.headers = headers;
	}

	/**
	 * Returns the request line.
	 */
	public RequestLine getRequestLine() {
		return requestLine;
	}

	/**
	 * Returns headers from the HTTP request.
	 */
	public MessageHeaders getHeaders() {
		return headers;
	}

	/**
	 * Returns a debug string.
	 */
	public String toString() {
		String s = "Request line=[" + requestLine + "] headers=";
		s += headers + " ";
		return s;

	}

}
