/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;


/**
 * Contains the contents of an HTTP response message.
 * In RFC 2616 terms, this object represents data found in the
 * <code>Response</code> body.
 */
public class Response
{

	private final StatusLine statusLine;
	private final MessageHeaders headers;

	/**
	 * Constructs a <code>Response</code> object by parts.
	 */
	public Response(StatusLine statusLine, MessageHeaders headers)
	{
		this.headers = headers;
		this.statusLine = statusLine;
	}

	public StatusLine getStatusLine() {
		return statusLine;
	}

	public MessageHeaders getHeaders() {
		return headers;
	}

	/**
	 * Returns true if the response should be continued.
	 */ 
	public boolean isContinue() {
		int code = getStatusLine().getStatusCode();
		return (code >= 100) && (code < 200);
	}

	/**
	 * Returns a debug string showing the response information contained
	 * within.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("ResponseImpl status=").append(getStatusLine()).append(" headers=[ ");
		sb.append(headers).append(' ');
		sb.append(']');
		return sb.toString();
	}

}
