/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import net.noderunner.http.ClientRequest;
import net.noderunner.http.ClientResponse;
import net.noderunner.http.HttpClient;
import net.noderunner.http.IllegalHttpStateException;

public class BasicHttpClient
implements HttpClient {
    private final InputStream is;
    private final OutputStream os;
    private final Writer writer;
    private Socket socket;
    private State state;

    public BasicHttpClient(Socket socket) throws IOException {
        this(socket.getOutputStream(), new BufferedInputStream(socket.getInputStream()));
        this.socket = socket;
    }

    public BasicHttpClient(OutputStream os, InputStream is) {
        if (os == null) {
            throw new IllegalArgumentException("Null OutputStream");
        }
        if (is == null) {
            throw new IllegalArgumentException("Null InputStream");
        }
        this.os = os;
        this.writer = new BufferedWriter(new OutputStreamWriter(os));
        this.is = is;
        this.state = State.INITIAL;
    }

    public void writeRequest(ClientRequest request) throws IOException {
        if (this.state != State.INITIAL) {
            throw new IllegalHttpStateException("Invalid HTTP state: " + this);
        }
        if (request == null) {
            throw new IllegalArgumentException("Null ClientRequest");
        }
        this.writer.write(request.getRequestLine().toString());
        this.writer.write("\r\n");
        request.getHeaders().write(this.writer);
        this.writer.write("\r\n");
        this.writer.flush();
        this.state = State.SENT_REQUEST;
        if (request.getDataPoster() != null) {
            request.getDataPoster().sendData(this.getOutputStream());
            this.writer.flush();
        }
    }

    public OutputStream getOutputStream() {
        if (this.state != State.SENT_REQUEST) {
            throw new IllegalHttpStateException("Invalid HTTP state");
        }
        this.state = State.GOT_INPUT;
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResponse readResponse() throws IOException {
        if (this.state != State.SENT_REQUEST && this.state != State.GOT_INPUT && this.state != State.CONTINUE) {
            throw new IllegalHttpStateException("Invalid HTTP state: " + (Object)((Object)this.state));
        }
        if (this.state == State.GOT_INPUT) {
            this.os.flush();
        }
        State done = State.INITIAL;
        try {
            ClientResponse response = new ClientResponse(this.is);
            if (response.isContinue()) {
                done = State.CONTINUE;
            }
            ClientResponse clientResponse = response;
            return clientResponse;
        }
        finally {
            this.state = done;
        }
    }

    public void close() throws IOException {
        this.state = State.CLOSED;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
        this.socket = null;
    }

    public String toString() {
        return "BasicHttpClient state=" + (Object)((Object)this.state) + " socket=" + this.socket;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        INITIAL,
        SENT_REQUEST,
        GOT_INPUT,
        CONTINUE,
        CLOSED;

    }
}

