/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import net.noderunner.http.MessageHeaders;

public class ChunkedInputStream
extends InputStream {
    private final InputStream stream;
    private boolean endChunk;
    private int chunkLength;
    private int chunkPos;
    private MessageHeaders entityHeaders;

    public ChunkedInputStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("InputStream parameter is null");
        }
        this.endChunk = false;
        this.chunkLength = 0;
        this.chunkPos = 0;
        this.stream = stream;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int want;
        int got;
        if (this.endChunk) {
            return -1;
        }
        if (this.chunkLength == this.chunkPos) {
            if (this.chunkLength > 0) {
                this.readChunkEnd();
            }
            this.chunkLength = this.readLengthFromStream();
            this.chunkPos = 0;
            if (this.chunkLength == 0) {
                this.readChunkTrailer();
                this.endChunk = true;
                return -1;
            }
        }
        if ((got = this.stream.read(b, off, want = Math.min(len, this.chunkLength - this.chunkPos))) == -1) {
            return -1;
        }
        this.chunkPos += got;
        return got;
    }

    public int read() throws IOException {
        byte[] oneChar = new byte[1];
        int c = this.read(oneChar, 0, 1);
        if (c == -1) {
            return -1;
        }
        return oneChar[0];
    }

    int readLengthFromStream() throws IOException {
        int ch;
        int total;
        block6: {
            total = 0;
            boolean extension = false;
            while (true) {
                if ((ch = this.stream.read()) == -1) {
                    throw new EOFException();
                }
                if (ch == 13) break block6;
                if (ch == 59) {
                    extension = true;
                }
                if (ch == 32 || extension) continue;
                total <<= 4;
                if (ch >= 48 && ch <= 57) {
                    total += ch - 48;
                    continue;
                }
                if (ch >= 97 && ch <= 102) {
                    total += ch - 97 + 10;
                    continue;
                }
                if (ch < 65 || ch > 70) break;
                total += ch - 65 + 10;
            }
            throw new IOException("Bad length character in stream: " + ch);
        }
        ch = this.stream.read();
        if (ch != 10) {
            throw new IOException("Expected LF character in stream: " + ch);
        }
        return total;
    }

    public MessageHeaders getEntityHeaders() {
        return this.entityHeaders;
    }

    public boolean isEndChunk() {
        return this.endChunk;
    }

    void readChunkEnd() throws IOException {
        int ch = this.stream.read();
        if (ch != 13) {
            throw new IOException("Expected CR in end chunk " + (char)ch);
        }
        ch = this.stream.read();
        if (ch != 10) {
            throw new IOException("Expected LN in end chunk");
        }
    }

    private void readChunkTrailer() throws IOException {
        this.entityHeaders = MessageHeaders.readHeaders(this.stream);
    }

    public String toString() {
        return "ChunkedInputStream  stream=" + this.stream + " chunkLength=" + this.chunkLength + " chunkPos=" + this.chunkPos;
    }
}

