/*
 * Decompiled with CFR 0.152.
 */
package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStream;
import net.noderunner.http.IllegalHttpStateException;

public class ChunkedOutputStream
extends OutputStream {
    private final OutputStream stream;
    private boolean doneChunking;
    private final byte[] lenEnc = new byte[]{48, 48, 48, 48, 13, 10};
    private static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public ChunkedOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream parameter is null");
        }
        this.stream = stream;
        this.doneChunking = false;
    }

    public void write(int b) throws IOException {
        if (this.doneChunking) {
            throw new IllegalHttpStateException("Already wrote last chunk");
        }
        this.writeChunkLen(1);
        this.stream.write(b);
        this.writeEndChunk();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.doneChunking) {
            throw new IllegalHttpStateException("Already wrote last chunk");
        }
        this.writeChunkLen(len);
        this.stream.write(b, off, len);
        this.writeEndChunk();
    }

    void writeChunkLen(int len) throws IOException {
        if (len > 65535) {
            this.lenEnc[0] = hex[len >> 28 & 0xF];
            this.lenEnc[1] = hex[len >> 24 & 0xF];
            this.lenEnc[2] = hex[len >> 20 & 0xF];
            this.lenEnc[3] = hex[len >> 16 & 0xF];
            this.stream.write(this.lenEnc, 0, 4);
        }
        this.lenEnc[0] = hex[len >> 12 & 0xF];
        this.lenEnc[1] = hex[len >> 8 & 0xF];
        this.lenEnc[2] = hex[len >> 4 & 0xF];
        this.lenEnc[3] = hex[len & 0xF];
        this.stream.write(this.lenEnc, 0, 6);
    }

    private void writeEndChunk() throws IOException {
        this.stream.write(this.lenEnc, 4, 2);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void doneOutput() throws IOException {
        if (!this.doneChunking) {
            this.writeChunkLen(0);
            this.writeEndChunk();
            this.doneChunking = true;
            this.flush();
        }
    }

    public void close() throws IOException {
        this.doneOutput();
        this.stream.close();
    }

    public String toString() {
        return "ChunkedOutputStream stream=" + this.stream + "doneChunking=" + this.doneChunking;
    }
}

